/*
 * Decompiled with CFR 0.152.
 */
package org.testmonkeys.maui.pageobjects.elements;

import java.util.List;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testmonkeys.maui.core.browser.Browser;
import org.testmonkeys.maui.core.elements.Component;
import org.testmonkeys.maui.core.elements.location.LocatesElements;
import org.testmonkeys.maui.core.elements.location.Locator;
import org.testmonkeys.maui.pageobjects.elements.html.HtmlElement;
import org.testmonkeys.maui.pageobjects.modules.LazyLoading;

public abstract class AbstractComponent
implements Component {
    protected WebElement webElement;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private Locator locator;
    private Browser browser;
    private LocatesElements parent;

    protected Logger getLogger() {
        return this.logger;
    }

    public HtmlElement getHtmlElement() {
        return new HtmlElement(this);
    }

    public void setWebElement(WebElement webElement) {
        this.webElement = webElement;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Locator getLocator() {
        return this.locator;
    }

    @Override
    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public LocatesElements getParent() {
        return this.parent;
    }

    @Override
    public void setParent(LocatesElements parent) {
        this.parent = parent;
    }

    @Override
    public WebElement find() {
        if (this.webElement != null && this.isAlive(this.webElement)) {
            return this.webElement;
        }
        this.webElement = this.parent == null ? this.browser.findElement(this.locator) : this.parent.findElement(this.locator);
        return this.webElement;
    }

    @Override
    public Browser getBrowser() {
        return this.browser;
    }

    @Override
    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    @Override
    public List<WebElement> findAll() {
        if (this.parent == null) {
            return this.browser.findElements(this.locator);
        }
        if (this.parent instanceof LazyLoading) {
            this.browser.getDynamicWaiter().until(p -> ((LazyLoading)((Object)this.parent)).isReady());
        }
        return this.parent.findElements(this.locator);
    }

    @Override
    public WebElement findElement(Locator elementLocator) {
        WebElement element = null;
        try {
            element = this.find().findElement(elementLocator.getSeleniumLocator());
        }
        catch (StaleElementReferenceException e) {
            element = this.find().findElement(elementLocator.getSeleniumLocator());
        }
        return element;
    }

    protected boolean isAlive(WebElement webElement) {
        boolean alive;
        try {
            webElement.isDisplayed();
            alive = true;
        }
        catch (Exception e) {
            alive = false;
        }
        this.getLogger().info("element is alive=" + alive + "; " + this);
        return alive;
    }

    @Override
    public List<WebElement> findElements(Locator elementLocator) {
        return this.find().findElements(elementLocator.getSeleniumLocator());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(name=" + this.getName() + ", locator[" + (Object)((Object)this.getLocator().getLocatorType()) + ", \"" + this.getLocator().getLocatorValue() + "\"])";
    }
}

