/*
 * Decompiled with CFR 0.152.
 */
package org.testmonkeys.maui.pageobjects.entitymapping;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.testmonkeys.maui.pageobjects.AbstractPage;
import org.testmonkeys.maui.pageobjects.entitymapping.EntityLink;
import org.testmonkeys.maui.pageobjects.entitymapping.MapsToField;

public class EntityInspector {
    private static EntityInspector instance;

    private EntityInspector() {
    }

    public static synchronized EntityInspector getInstance() {
        if (instance == null) {
            instance = new EntityInspector();
        }
        return instance;
    }

    public EntityLink inspectLink(Type type, AbstractPage page) {
        return this.inspectLink(type.getClass(), page);
    }

    public EntityLink inspectLink(Class<?> entityClazz, AbstractPage page) {
        EntityLink link = new EntityLink();
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(entityClazz, Object.class);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        Method[] pageMethods = page.getClass().getMethods();
        HashMap<String, Method> customLinkDictionary = new HashMap<String, Method>();
        for (Method method : pageMethods) {
            String fieldName = this.getCustomMapping(method, entityClazz);
            if (fieldName == null) continue;
            customLinkDictionary.put(fieldName, method);
        }
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            String name = propertyDescriptor.getName();
            Method method = customLinkDictionary.containsKey(name) ? (Method)customLinkDictionary.get(name) : this.getPageElement(name, pageMethods);
            if (method == null) continue;
            link.addMapping(propertyDescriptor, method);
        }
        return link;
    }

    private String getCustomMapping(AnnotatedElement member, Class clazz) {
        ArrayList knownAnnotations = new ArrayList();
        for (Annotation candidate : member.getAnnotations()) {
            if (!(candidate instanceof MapsToField) || !((MapsToField)candidate).clazz().equals(clazz)) continue;
            return ((MapsToField)candidate).value();
        }
        return null;
    }

    private Method getPageElement(String name, Method[] methods) {
        for (Method method : methods) {
            if (!method.getName().equalsIgnoreCase(name) && !method.getName().equalsIgnoreCase("get" + name)) continue;
            return method;
        }
        return null;
    }
}

