/*
 * Decompiled with CFR 0.152.
 */
package org.testmonkeys.maui.pageobjects.entitymapping;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.testmonkeys.maui.pageobjects.elements.FillableComponent;
import org.testmonkeys.maui.pageobjects.elements.ReadableComponent;

public class EntityLink {
    private Map<PropertyDescriptor, Method> mapping = new HashMap<PropertyDescriptor, Method>();

    public void addMapping(PropertyDescriptor propertyDescriptor, Method method) {
        this.mapping.put(propertyDescriptor, method);
    }

    public void fillPage(Object entity, Object page) {
        for (PropertyDescriptor propertyDescriptor : this.mapping.keySet()) {
            Object entityValue = null;
            try {
                entityValue = propertyDescriptor.getReadMethod().invoke(entity, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            Method method = this.mapping.get(propertyDescriptor);
            FillableComponent input = null;
            try {
                input = (FillableComponent)method.invoke(page, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            if (input == null || entityValue == null) continue;
            input.fill(entityValue);
        }
    }

    public <T> T read(Class<T> clazz, Object page) {
        T ret = null;
        try {
            ret = clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        for (PropertyDescriptor propertyDescriptor : this.mapping.keySet()) {
            Method method = this.mapping.get(propertyDescriptor);
            ReadableComponent input = null;
            try {
                input = (ReadableComponent)method.invoke(page, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            try {
                propertyDescriptor.getWriteMethod().invoke(ret, input.read());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }
}

