/*
 * Decompiled with CFR 0.152.
 */
package org.testmonkeys.maui.core.elements.actions;

import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testmonkeys.maui.core.elements.actions.ActionHooksContext;
import org.testmonkeys.maui.pageobjects.elements.AbstractComponent;

public abstract class AbstractAction<T> {
    protected AbstractComponent component;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private FluentWait<AbstractComponent> retryMech;

    public AbstractAction(AbstractComponent component) {
        this.retryMech = new FluentWait((Object)component).ignoring(WebDriverException.class).pollingEvery(1L, TimeUnit.SECONDS).withTimeout(10L, TimeUnit.SECONDS);
        this.component = component;
    }

    public T execute() {
        ActionHooksContext.getContext().getBeforeHooks().forEach(hook -> hook.accept(this.component));
        this.logger.trace("Executing action upon " + this.component);
        this.logger.info(this.describeAction());
        T actionResult = this.executeAction(this.component.find());
        if (actionResult != null) {
            this.logger.info("Action result is '" + actionResult + "'");
        }
        this.logger.trace("Action result is = " + actionResult);
        ActionHooksContext.getContext().getAfterHooks().forEach(hook -> hook.accept(this.component));
        return actionResult;
    }

    protected abstract T executeAction(WebElement var1);

    protected String describeAction() {
        return "Executing action upon " + this.component;
    }
}

