/*
 * Decompiled with CFR 0.152.
 */
package org.testmonkeys.maui.core.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ReflectionUtils {
    public static List<Field> extractFieldsByPredicate(Class<?> type, Predicate<Field> predicate) {
        List<Field> fields = Arrays.asList(ReflectionUtils.getAllFields(type));
        return fields.stream().filter(predicate).collect(Collectors.toList());
    }

    private static Field[] getAllFields(Class<?> clazz) {
        List<Class<?>> classes = ReflectionUtils.getAllSuperclasses(clazz);
        classes.add(clazz);
        return ReflectionUtils.getAllFields(classes);
    }

    private static Field[] getAllFields(List<Class<?>> classes) {
        HashSet fields = new HashSet();
        classes.forEach(c -> fields.addAll(Arrays.asList(c.getDeclaredFields())));
        return fields.toArray(new Field[fields.size()]);
    }

    private static List<Class<?>> getAllSuperclasses(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        for (Class<?> superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            classes.add(superclass);
        }
        return classes;
    }

    public <T> T instantiate(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

