/*
 * Decompiled with CFR 0.152.
 */
package org.testmonkeys.maui.pageobjects.elements;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.testmonkeys.maui.pageobjects.elements.GroupComponent;
import org.testmonkeys.maui.pageobjects.elements.RadioButton;

public class RadioButtonGroup
extends GroupComponent<RadioButton> {
    public RadioButtonGroup() {
        this.setItemType((Type)((Object)RadioButton.class));
    }

    public List<String> getValues() {
        List options = this.getAll();
        ArrayList<String> values = new ArrayList<String>();
        for (RadioButton element : options) {
            values.add(element.getValue());
        }
        return values;
    }

    public void selectByValue(String value) {
        Optional<RadioButton> option = this.getAll().stream().filter(o -> value.equals(o.getValue())).findFirst();
        if (!option.isPresent()) {
            throw new NoSuchElementException("Could not find radio button by value " + value);
        }
        option.get().select();
    }

    public void selectByIndex(int index) {
        List options = this.getAll();
        if (options.size() <= index) {
            throw new IndexOutOfBoundsException("Could not find radio button by index " + index + ", radio button group size is " + options.size());
        }
        ((RadioButton)options.get(index)).select();
    }

    public String getSelectedValue() {
        List options = this.getAll();
        for (RadioButton element : options) {
            if (!element.isSelected()) continue;
            return element.getValue();
        }
        return null;
    }

    public int getSelectedIndex() {
        List options = this.getAll();
        for (int i = 0; i < options.size(); ++i) {
            if (!((RadioButton)options.get(i)).isSelected()) continue;
            return i;
        }
        return -1;
    }
}

