/*
 * Decompiled with CFR 0.152.
 */
package org.testmonkeys.maui.pageobjects.elements;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.testmonkeys.maui.pageobjects.elements.CheckBox;
import org.testmonkeys.maui.pageobjects.elements.FillableComponent;
import org.testmonkeys.maui.pageobjects.elements.GroupComponent;

public class CheckBoxButtonGroup
extends GroupComponent<CheckBox>
implements FillableComponent<Set<Enum>> {
    public CheckBoxButtonGroup() {
        this.setItemType((Type)((Object)CheckBox.class));
    }

    public List<String> getValues() {
        List options = this.getAll();
        ArrayList<String> values = new ArrayList<String>();
        for (CheckBox element : options) {
            values.add(element.getValue());
        }
        return values;
    }

    public void selectByValue(String value) {
        Optional<CheckBox> option = this.getAll().stream().filter(o -> value.equalsIgnoreCase(o.getValue())).findFirst();
        if (!option.isPresent()) {
            throw new NoSuchElementException("Could not find radio button by value " + value);
        }
        option.get().check();
    }

    public void selectByIndex(int index) {
        List options = this.getAll();
        if (options.size() <= index) {
            throw new IndexOutOfBoundsException("Could not find radio button by index " + index + ", radio button group size is " + options.size());
        }
        ((CheckBox)options.get(index)).check();
    }

    @Override
    public void fill(Set<Enum> values) {
        for (Enum value : values) {
            this.selectByValue(value.toString());
        }
    }
}

