/*
 * Decompiled with CFR 0.152.
 */
package org.testmonkeys.maui.core.elements.actions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.testmonkeys.maui.core.elements.actions.AbstractAction;
import org.testmonkeys.maui.pageobjects.elements.AbstractComponent;

public class ExecuteJSScript
extends AbstractAction<Object> {
    private String script;
    private Object[] args;

    public ExecuteJSScript(AbstractComponent component, String script, Object ... args) {
        super(component);
        this.args = args;
        this.script = this.createExecutableScript(script, args);
    }

    private String createExecutableScript(String script, Object[] args) {
        StringBuilder arguments = new StringBuilder();
        for (int i = 0; i <= args.length; ++i) {
            arguments.append("arguments[").append(i).append("]");
            if (i >= args.length) continue;
            arguments.append(",");
        }
        return this.getScript(script) + "\nreturn fun(" + arguments + ");";
    }

    @Override
    protected Object executeAction(WebElement webElement) {
        WebDriver webDriver = this.component.getBrowser().getDriver();
        if (!(webDriver instanceof JavascriptExecutor)) {
            throw new RuntimeException("Browser can't execute java script");
        }
        JavascriptExecutor jsExecutor = (JavascriptExecutor)webDriver;
        return jsExecutor.executeScript(this.script, this.aggregateArgs(webElement));
    }

    private Object[] aggregateArgs(WebElement webElement) {
        Object[] aggregatedArgs = new Object[this.args.length + 1];
        aggregatedArgs[0] = webElement;
        System.arraycopy(this.args, 0, aggregatedArgs, 1, this.args.length);
        return aggregatedArgs;
    }

    private String getScript(String fileName) {
        StringBuilder result = new StringBuilder("");
        InputStream in = this.getClass().getResourceAsStream(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toString();
    }
}

