/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.reportng;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.testng.IReporter;
import org.uncommons.reportng.ReportMetadata;
import org.uncommons.reportng.ReportNGUtils;

public abstract class AbstractReporter
implements IReporter {
    private static final String ENCODING = "UTF-8";
    private static final String META_KEY = "meta";
    protected static final ReportMetadata META = new ReportMetadata();
    private static final String UTILS_KEY = "utils";
    private static final ReportNGUtils UTILS = new ReportNGUtils();
    private static final String MESSAGES_KEY = "messages";
    private static final ResourceBundle MESSAGES = ResourceBundle.getBundle("org.uncommons.reportng.messages.reportng", META.getLocale());
    private final String classpathPrefix;

    public AbstractReporter(String classpathPrefix) {
        this.classpathPrefix = classpathPrefix;
    }

    public Map<String, Object> createContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(META_KEY, META);
        context.put(MESSAGES_KEY, MESSAGES);
        context.put(UTILS_KEY, UTILS);
        return context;
    }

    void generateFile(File file, String templateName, Map<String, Object> context) throws IOException, TemplateException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);
            URL resource = this.getClass().getClassLoader().getResource(this.classpathPrefix);
            if (resource == null) {
                throw new IllegalArgumentException("Unable to find resources :" + this.classpathPrefix);
            }
            cfg.setDirectoryForTemplateLoading(new File(resource.getPath()));
            cfg.setDefaultEncoding(ENCODING);
            cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            cfg.setLogTemplateExceptions(false);
            cfg.setWrapUncheckedExceptions(true);
            Template template = cfg.getTemplate(templateName);
            template.process(context, (Writer)writer);
            ((Writer)writer).flush();
        }
    }

    protected void copyClasspathResource(File outputDirectory, String resourceName, String targetFileName) throws IOException {
        String resourcePath = this.classpathPrefix + resourceName;
        InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        this.copyStream(outputDirectory, resourceStream, targetFileName);
    }

    protected void copyFile(File outputDirectory, File sourceFile, String targetFileName) throws IOException {
        try (FileInputStream fileStream = new FileInputStream(sourceFile);){
            this.copyStream(outputDirectory, fileStream, targetFileName);
        }
    }

    protected void copyStream(File outputDirectory, InputStream stream, String targetFileName) throws IOException {
        File resourceFile = new File(outputDirectory, targetFileName);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, ENCODING));
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(resourceFile), ENCODING));){
            String line = reader.readLine();
            while (line != null) {
                writer.write(line);
                ((Writer)writer).write(10);
                line = reader.readLine();
            }
            ((Writer)writer).flush();
        }
    }

    protected void removeEmptyDirectories(File outputDirectory) {
        if (outputDirectory == null || !outputDirectory.exists()) {
            return;
        }
        Arrays.stream(Objects.requireNonNull(outputDirectory.listFiles())).filter(file -> file.isDirectory() && Objects.requireNonNull(file.listFiles()).length == 0).forEach(File::delete);
    }
}

