/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.reportng;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;

public final class ReportMetadata {
    static final String PROPERTY_KEY_PREFIX = "org.uncommons.reportng.";
    static final String TITLE_KEY = "org.uncommons.reportng.title";
    static final String DEFAULT_TITLE = "Test Results Report";
    static final String COVERAGE_KEY = "org.uncommons.reportng.coverage-report";
    static final String EXCEPTIONS_KEY = "org.uncommons.reportng.show-expected-exceptions";
    static final String OUTPUT_KEY = "org.uncommons.reportng.escape-output";
    static final String XML_DIALECT_KEY = "org.uncommons.reportng.xml-dialect";
    static final String STYLESHEET_KEY = "org.uncommons.reportng.stylesheet";
    static final String LOCALE_KEY = "org.uncommons.reportng.locale";
    private final DateFormat dateFormat = new SimpleDateFormat("EEEE dd MMMM yyyy");
    private final DateFormat timeFormat = new SimpleDateFormat("HH:mm z");
    private final Date reportTime = new Date();

    public String getReportDate() {
        return this.dateFormat.format(this.reportTime);
    }

    public String getReportTime() {
        return this.timeFormat.format(this.reportTime);
    }

    public String getReportTitle() {
        return System.getProperty(TITLE_KEY, DEFAULT_TITLE);
    }

    public String getCoverageLink() {
        return System.getProperty(COVERAGE_KEY);
    }

    public File getStylesheetPath() {
        String path = System.getProperty(STYLESHEET_KEY);
        return path == null ? null : new File(path);
    }

    public boolean shouldShowExpectedExceptions() {
        return System.getProperty(EXCEPTIONS_KEY, "false").equalsIgnoreCase("true");
    }

    public boolean shouldEscapeOutput() {
        return System.getProperty(OUTPUT_KEY, "true").equalsIgnoreCase("true");
    }

    public boolean allowSkippedTestsInXML() {
        return !System.getProperty(XML_DIALECT_KEY, "testng").equalsIgnoreCase("junit");
    }

    public String getUser() throws UnknownHostException {
        String user = System.getProperty("user.name");
        String host = InetAddress.getLocalHost().getHostName();
        return user + '@' + host;
    }

    public String getJavaInfo() {
        return String.format("Java %s (%s)", System.getProperty("java.version"), System.getProperty("java.vendor"));
    }

    public String getPlatform() {
        return String.format("%s %s (%s)", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    }

    public static Locale getLocale() {
        if (System.getProperties().containsKey(LOCALE_KEY)) {
            String locale = System.getProperty(LOCALE_KEY);
            String[] components = locale.split("_", 3);
            switch (components.length) {
                case 1: {
                    return new Locale(locale);
                }
                case 2: {
                    return new Locale(components[0], components[1]);
                }
                case 3: {
                    return new Locale(components[0], components[1], components[2]);
                }
            }
            Logger.getLogger(ReportMetadata.class.getName()).warning(() -> "Invalid locale specified: " + locale + ", use default locale instead.");
        }
        return Locale.getDefault();
    }
}

