/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.cubaentityloader;

import com.haulmont.cuba.core.entity.Entity;
import com.haulmont.cuba.core.global.DataManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.thepavel.cubaentityloader.query.QueryRunner;
import org.thepavel.cubaentityloader.queryparams.ParamsSupplier;

public class EntityLoader<T extends Entity<K>, K> {
    private final DataManager dataManager;
    private final Class<T> entityClass;
    private final String view;
    private final String query;
    private final List<ParamsSupplier> paramsSuppliers;

    public EntityLoader(DataManager dataManager, Class<T> entityClass, String view, String query, List<ParamsSupplier> paramsSuppliers) {
        this.dataManager = dataManager;
        this.entityClass = entityClass;
        this.view = view;
        this.query = query;
        this.paramsSuppliers = paramsSuppliers;
    }

    public List<T> list() {
        return this.queryRunner().list();
    }

    public List<T> page(int firstResult, int maxResults) {
        return this.queryRunner().page(firstResult, maxResults);
    }

    public T one() {
        return this.queryRunner().one();
    }

    public Optional<T> optional() {
        return this.queryRunner().optional();
    }

    public T one(K id) {
        return this.queryRunner().one(id);
    }

    public Optional<T> optional(K id) {
        return this.queryRunner().optional(id);
    }

    public long count() {
        return this.queryRunner().count();
    }

    public QueryRunner<T, K> view(String view) {
        return this.queryRunner().view(view);
    }

    public QueryRunner<T, K> param(String name, Object value) {
        return this.queryRunner().param(name, value);
    }

    public QueryRunner<T, K> params(Map<String, Object> params) {
        return this.queryRunner().params(params);
    }

    private QueryRunner<T, K> queryRunner() {
        return new QueryRunner(this.dataManager, this.entityClass, this.view, this.query, this.paramsSuppliers);
    }
}

