/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.cubaentityloader;

import com.haulmont.cuba.core.entity.Entity;
import com.haulmont.cuba.core.global.DataManager;
import java.lang.reflect.Field;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.thepavel.cubaentityloader.EntityLoader;
import org.thepavel.cubaentityloader.FieldContext;
import org.thepavel.cubaentityloader.annotations.Secure;
import org.thepavel.cubaentityloader.query.QueryFactory;
import org.thepavel.cubaentityloader.queryparams.ParamsSupplier;
import org.thepavel.cubaentityloader.queryparams.ParamsSuppliersFactory;
import org.thepavel.cubaentityloader.utils.ReflectionHelper;
import org.thepavel.cubaentityloader.view.ViewFactory;

@Component
public class EntityLoaderFactory {
    @Inject
    private DataManager dataManager;
    @Inject
    private QueryFactory queryFactory;
    @Inject
    private ParamsSuppliersFactory paramsSuppliersFactory;

    public <T extends Entity<K>, K> EntityLoader<T, K> createEntityLoader(FieldContext fieldContext) {
        Field field = fieldContext.getField();
        DataManager dataManager = this.getDataManager(field);
        Class<T> entityClass = EntityLoaderFactory.getEntityClass(field);
        String view = ViewFactory.getView(field);
        String query = this.queryFactory.getQuery(field, entityClass);
        List<ParamsSupplier> paramsSuppliers = this.getParamsSuppliers(fieldContext);
        return new EntityLoader(dataManager, entityClass, view, query, paramsSuppliers);
    }

    private DataManager getDataManager(Field field) {
        boolean isSecure = field.isAnnotationPresent(Secure.class);
        return isSecure ? this.dataManager.secure() : this.dataManager;
    }

    private static <T extends Entity<K>, K> Class<T> getEntityClass(Field field) {
        return ReflectionHelper.getGenericTypes(field)[0];
    }

    private List<ParamsSupplier> getParamsSuppliers(FieldContext fieldContext) {
        return this.paramsSuppliersFactory.getParamsSuppliers(fieldContext);
    }
}

