/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.cubaentityloader.query;

import com.haulmont.cuba.core.global.MetadataTools;
import java.lang.reflect.Field;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.thepavel.cubaentityloader.annotations.Query;

@Component
public class QueryFactory {
    private static final String DEFAULT_QUERY = "select e from %s e";
    @Inject
    private MetadataTools metadataTools;

    public String getQuery(Field field, Class<?> entityClass) {
        if (field.isAnnotationPresent(Query.class)) {
            return field.getAnnotation(Query.class).value();
        }
        return this.getDefaultQuery(entityClass);
    }

    private String getDefaultQuery(Class<?> entityClass) {
        return String.format(DEFAULT_QUERY, this.getEntityName(entityClass));
    }

    private String getEntityName(Class<?> entityClass) {
        return this.metadataTools.getEntityName(entityClass);
    }
}

