/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.cubaentityloader.injectors;

import java.lang.reflect.Field;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.thepavel.cubaentityloader.EntityLoader;
import org.thepavel.cubaentityloader.EntityLoaderFactory;
import org.thepavel.cubaentityloader.FieldContext;
import org.thepavel.cubaentityloader.utils.ReflectionHelper;

@Component
public class EntityLoaderInjector {
    @Inject
    private EntityLoaderFactory entityLoaderFactory;

    public void inject(Object instance) {
        ReflectionUtils.doWithFields(instance.getClass(), field -> this.assignEntityLoader(field, instance), this::isEntityLoaderField);
    }

    private void assignEntityLoader(Field field, Object instance) {
        ReflectionHelper.setValue(field, instance, this.createEntityLoader(field, instance));
    }

    private Object createEntityLoader(Field field, Object instance) {
        return this.entityLoaderFactory.createEntityLoader(new FieldContext(field, instance));
    }

    private boolean isEntityLoaderField(Field field) {
        return field.getType().equals(EntityLoader.class);
    }
}

