/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.cubaentityloader.query;

import com.haulmont.cuba.core.entity.Entity;
import com.haulmont.cuba.core.global.DataManager;
import com.haulmont.cuba.core.global.FluentLoader;
import com.haulmont.cuba.core.global.LoadContext;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.thepavel.cubaentityloader.query.QueryRunnerParams;
import org.thepavel.cubaentityloader.queryparams.ParamsSupplier;

public class QueryRunner<T extends Entity<K>, K> {
    private final DataManager dataManager;
    private final Class<T> entityClass;
    private String view;
    private final String query;
    private final QueryRunnerParams params;

    public QueryRunner(DataManager dataManager, Class<T> entityClass, String view, String query, List<ParamsSupplier> paramsSuppliers) {
        this.dataManager = dataManager;
        this.entityClass = entityClass;
        this.view = view;
        this.query = query;
        this.params = new QueryRunnerParams(paramsSuppliers);
    }

    public List<T> list() {
        return this.byQueryLoader().list();
    }

    public List<T> page(int firstResult, int maxResults) {
        return this.byQueryLoader().firstResult(firstResult).maxResults(maxResults).list();
    }

    public T one() {
        return (T)this.byQueryLoader().one();
    }

    public Optional<T> optional() {
        return this.byQueryLoader().optional();
    }

    private FluentLoader.ByQuery<T, K> byQueryLoader() {
        return this.dataManager.load(this.entityClass).view(this.view).query(this.query).setParameters(this.params.get());
    }

    public T one(K id) {
        return (T)this.byIdLoader(id).one();
    }

    public Optional<T> optional(K id) {
        return this.byIdLoader(id).optional();
    }

    private FluentLoader.ById<T, K> byIdLoader(K id) {
        return this.dataManager.load(this.entityClass).view(this.view).id(id);
    }

    public long count() {
        LoadContext.Query query = LoadContext.createQuery((String)this.query).setParameters(this.params.get());
        LoadContext context = LoadContext.create(this.entityClass).setView(this.view).setQuery(query);
        return this.dataManager.getCount(context);
    }

    public QueryRunner<T, K> view(String view) {
        this.view = view;
        return this;
    }

    public QueryRunner<T, K> param(String name, Object value) {
        this.params.add(name, value);
        return this;
    }

    public QueryRunner<T, K> params(Map<String, Object> params) {
        this.params.add(params);
        return this;
    }
}

