/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.cubaentityloader.queryparams;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.thepavel.cubaentityloader.FieldContext;
import org.thepavel.cubaentityloader.annotations.QueryParam;
import org.thepavel.cubaentityloader.annotations.QueryParamList;
import org.thepavel.cubaentityloader.queryparams.MethodInvocationIndividualParamsSupplier;
import org.thepavel.cubaentityloader.queryparams.ParamsSupplier;
import org.thepavel.cubaentityloader.queryparams.ParamsSupplierFactory;

@Component
@Order(value=1)
public class MethodInvocationIndividualParamsSupplierFactory
implements ParamsSupplierFactory {
    @Override
    public ParamsSupplier createParamsSupplier(FieldContext fieldContext) {
        Map<String, String> paramsToMethodsMap = MethodInvocationIndividualParamsSupplierFactory.getParamsToMethodsMap(fieldContext);
        return new MethodInvocationIndividualParamsSupplier(paramsToMethodsMap, fieldContext.getInstance());
    }

    private static Map<String, String> getParamsToMethodsMap(FieldContext fieldContext) {
        Field field = fieldContext.getField();
        return Arrays.stream(field.getAnnotationsByType(QueryParam.class)).collect(Collectors.toMap(QueryParam::name, QueryParam::supplier));
    }

    @Override
    public boolean isApplicable(FieldContext fieldContext) {
        Field field = fieldContext.getField();
        return field.isAnnotationPresent(QueryParam.class) || field.isAnnotationPresent(QueryParamList.class);
    }
}

