/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.cubaentityloader.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.util.ReflectionUtils;

public class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static Object invokeMethod(String name, Object instance) {
        Class<?> type = instance.getClass();
        Method method = ReflectionUtils.findMethod(type, (String)name);
        if (method == null) {
            throw new IllegalArgumentException("Class " + type + " has no method " + name);
        }
        ReflectionHelper.makeAccessible(method);
        return ReflectionUtils.invokeMethod((Method)method, (Object)instance);
    }

    public static void setValue(Field field, Object instance, Object value) {
        ReflectionHelper.makeAccessible(field);
        ReflectionUtils.setField((Field)field, (Object)instance, (Object)value);
    }

    private static void makeAccessible(AccessibleObject object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
    }

    public static Class<?>[] getGenericTypes(Field field) {
        Type fieldType = field.getGenericType();
        if (!(fieldType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Generic type is not specified for the field " + field.getName());
        }
        ParameterizedType type = (ParameterizedType)fieldType;
        return ReflectionHelper.toClass(type.getActualTypeArguments());
    }

    private static Class<?>[] toClass(Type[] types) {
        Class[] classes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            classes[i] = (Class)types[i];
        }
        return classes;
    }
}

