/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.icomponent.annotation;

import java.lang.annotation.Annotation;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.stereotype.Component;
import org.thepavel.icomponent.annotation.MarkerAnnotationResolver;
import org.thepavel.icomponent.util.AnnotationAttributes;

public abstract class BaseMarkerAnnotationResolver
implements MarkerAnnotationResolver {
    protected abstract Class<? extends Annotation> getDeclaringAnnotationType();

    protected String getAnnotationAttributeName() {
        return "annotation";
    }

    protected String getBeanNameAttributeName() {
        return "beanNameAnnotationAttribute";
    }

    protected Class<? extends Annotation> getDefaultAnnotationClass() {
        return Component.class;
    }

    protected String getDefaultBeanNameAnnotationAttribute() {
        return "value";
    }

    @Override
    public Class<? extends Annotation> getAnnotationType(AnnotationMetadata metadata) {
        return this.getAnnotationAttributes(metadata).getClass(this.getAnnotationAttributeName()).orElseGet(this::getDefaultAnnotationClass);
    }

    @Override
    public String getBeanNameAnnotationAttribute(AnnotationMetadata metadata) {
        return this.getAnnotationAttributes(metadata).getString(this.getBeanNameAttributeName()).orElseGet(this::getDefaultBeanNameAnnotationAttribute);
    }

    private AnnotationAttributes<?> getAnnotationAttributes(AnnotationMetadata metadata) {
        return AnnotationAttributes.of(this.getDeclaringAnnotationType()).declaredOn((AnnotatedTypeMetadata)metadata);
    }
}

