/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.icomponent.metadata;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.annotation.MergedAnnotations;
import org.thepavel.icomponent.metadata.ClassMetadata;
import org.thepavel.icomponent.metadata.MethodMetadata;

public class ClassMetadataImpl
implements ClassMetadata {
    private final Class<?> sourceClass;
    private final MergedAnnotations annotations;
    private final Map<Method, MethodMetadata> methodMetadataMap = new HashMap<Method, MethodMetadata>();

    public ClassMetadataImpl(Class<?> sourceClass, MergedAnnotations annotations) {
        this.sourceClass = sourceClass;
        this.annotations = annotations;
    }

    @Override
    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public MergedAnnotations getAnnotations() {
        return this.annotations;
    }

    @Override
    public Collection<MethodMetadata> getMethodsMetadata() {
        return Collections.unmodifiableCollection(this.methodMetadataMap.values());
    }

    @Override
    public MethodMetadata getMethodMetadata(Method method) {
        return this.methodMetadataMap.get(method);
    }

    public void addMethodMetadata(MethodMetadata metadata) {
        this.methodMetadataMap.put(metadata.getSourceMethod(), metadata);
    }
}

