/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.icomponent.packageresolver;

import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.thepavel.icomponent.packageresolver.PackageResolver;
import org.thepavel.icomponent.util.AnnotationAttributes;

public abstract class BaseAnnotationPackageResolver
implements PackageResolver {
    private Set<String> result;

    protected abstract Class<? extends Annotation> getAnnotationType();

    protected String getBasePackagesAttributeName() {
        return "basePackages";
    }

    protected String getBasePackageClassesAttributeName() {
        return "basePackageClasses";
    }

    @Override
    public String[] getPackageNames(AnnotationMetadata metadata) {
        this.result = new LinkedHashSet<String>();
        this.collectFromAnnotation(metadata);
        if (this.result.isEmpty()) {
            this.collectFromClassName(metadata);
        }
        return this.result.toArray(new String[0]);
    }

    private void collectFromAnnotation(AnnotationMetadata metadata) {
        AnnotationAttributes<?> attributes = this.getAnnotationAttributes(metadata);
        this.collectFromBasePackages(attributes);
        this.collectFromBasePackageClasses(attributes);
    }

    private AnnotationAttributes<?> getAnnotationAttributes(AnnotationMetadata metadata) {
        return AnnotationAttributes.of(this.getAnnotationType()).declaredOn((AnnotatedTypeMetadata)metadata);
    }

    private void collectFromBasePackages(AnnotationAttributes<?> attributes) {
        String attributeName = this.getBasePackagesAttributeName();
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            return;
        }
        attributes.getStrings(attributeName).ifPresent(this.result::addAll);
    }

    private void collectFromBasePackageClasses(AnnotationAttributes<?> attributes) {
        String attributeName = this.getBasePackageClassesAttributeName();
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            return;
        }
        attributes.getClasses(attributeName).ifPresent(this::collectFromClasses);
    }

    private void collectFromClasses(List<Class<?>> classes) {
        classes.stream().map(ClassUtils::getPackageName).forEach(this.result::add);
    }

    private void collectFromClassName(AnnotationMetadata metadata) {
        this.result.add(BaseAnnotationPackageResolver.getPackageOfClass(metadata));
    }

    private static String getPackageOfClass(AnnotationMetadata metadata) {
        return ClassUtils.getPackageName((String)metadata.getClassName());
    }
}

