/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.icomponent.metadata.factory;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.ReflectionUtils;
import org.thepavel.icomponent.generic.GenericTypeParametersResolver;
import org.thepavel.icomponent.metadata.ClassMetadata;
import org.thepavel.icomponent.metadata.MethodMetadata;
import org.thepavel.icomponent.metadata.MethodMetadataImpl;
import org.thepavel.icomponent.metadata.ResolvedTypeMetadata;
import org.thepavel.icomponent.metadata.factory.ExceptionMetadataFactory;
import org.thepavel.icomponent.metadata.factory.ParameterMetadataFactory;
import org.thepavel.icomponent.metadata.factory.ReturnTypeMetadataFactory;
import org.thepavel.icomponent.util.MethodHelper;

class MethodMetadataFactory {
    private final ReturnTypeMetadataFactory returnTypeMetadataFactory;
    private final ParameterMetadataFactory parameterMetadataFactory;
    private final ExceptionMetadataFactory exceptionMetadataFactory;

    MethodMetadataFactory(GenericTypeParametersResolver typeParametersResolver) {
        this.returnTypeMetadataFactory = new ReturnTypeMetadataFactory(typeParametersResolver);
        this.parameterMetadataFactory = new ParameterMetadataFactory(typeParametersResolver);
        this.exceptionMetadataFactory = new ExceptionMetadataFactory(typeParametersResolver);
    }

    List<MethodMetadata> getMethodMetadata(ClassMetadata classMetadata) {
        ArrayList<MethodMetadata> result = new ArrayList<MethodMetadata>();
        ReflectionUtils.doWithMethods(classMetadata.getSourceClass(), method -> result.add(this.getMethodMetadata(classMetadata, method)), method -> !MethodHelper.isStatic(method));
        return result;
    }

    private MethodMetadata getMethodMetadata(ClassMetadata classMetadata, Method method) {
        MethodMetadataImpl methodMetadata = new MethodMetadataImpl(classMetadata, method);
        methodMetadata.setReturnTypeMetadata(this.getReturnTypeMetadata(method));
        methodMetadata.setAnnotations(MergedAnnotations.from((AnnotatedElement)method));
        this.addParametersMetadata(methodMetadata);
        this.addExceptionsMetadata(methodMetadata);
        return methodMetadata;
    }

    private ResolvedTypeMetadata getReturnTypeMetadata(Method method) {
        return this.returnTypeMetadataFactory.getReturnTypeMetadata(method);
    }

    private void addParametersMetadata(MethodMetadataImpl methodMetadata) {
        this.parameterMetadataFactory.getParameterMetadata(methodMetadata.getSourceMethod()).forEach(methodMetadata::addParameterMetadata);
    }

    private void addExceptionsMetadata(MethodMetadataImpl methodMetadata) {
        this.exceptionMetadataFactory.getExceptionMetadata(methodMetadata.getSourceMethod()).forEach(methodMetadata::addExceptionMetadata);
    }
}

