/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.icomponent.packageresolver;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.util.ClassUtils;
import org.thepavel.icomponent.packageresolver.PackageResolver;
import org.thepavel.icomponent.util.AnnotationAttributes;

public class DefaultPackageResolver
implements PackageResolver {
    private Set<String> result;

    protected String getBasePackagesAttributeName() {
        return "basePackages";
    }

    protected String getBasePackageClassesAttributeName() {
        return "basePackageClasses";
    }

    @Override
    public String[] getPackageNames(MergedAnnotation<?> annotation, String className) {
        this.result = new LinkedHashSet<String>();
        this.collectFromAnnotation(annotation);
        if (this.result.isEmpty()) {
            this.collectFromClassName(className);
        }
        return this.result.toArray(new String[0]);
    }

    private void collectFromAnnotation(MergedAnnotation<?> annotation) {
        AnnotationAttributes<?> attributes = AnnotationAttributes.of(annotation);
        this.collectFromBasePackages(attributes);
        this.collectFromBasePackageClasses(attributes);
    }

    private void collectFromBasePackages(AnnotationAttributes<?> attributes) {
        String attributeName = this.getBasePackagesAttributeName();
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            return;
        }
        attributes.getStrings(attributeName).ifPresent(this.result::addAll);
    }

    private void collectFromBasePackageClasses(AnnotationAttributes<?> attributes) {
        String attributeName = this.getBasePackageClassesAttributeName();
        if (StringUtils.isBlank((CharSequence)attributeName)) {
            return;
        }
        attributes.getClasses(attributeName).ifPresent(this::collectFromClasses);
    }

    private void collectFromClasses(List<Class<?>> classes) {
        classes.stream().map(ClassUtils::getPackageName).forEach(this.result::add);
    }

    private void collectFromClassName(String className) {
        this.result.add(ClassUtils.getPackageName((String)className));
    }
}

