/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.icomponent.proxy;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.ReflectionUtils;
import org.thepavel.icomponent.handler.MethodHandler;
import org.thepavel.icomponent.handler.MethodHandlerMap;
import org.thepavel.icomponent.metadata.ClassMetadata;
import org.thepavel.icomponent.metadata.MethodMetadata;
import org.thepavel.icomponent.util.MethodInvocationHelper;

public class InterfaceComponentInterceptor
implements MethodInterceptor {
    private final ClassMetadata classMetadata;
    private final MethodHandlerMap methodHandlerMap;

    public InterfaceComponentInterceptor(ClassMetadata classMetadata, MethodHandlerMap methodHandlerMap) {
        this.classMetadata = classMetadata;
        this.methodHandlerMap = methodHandlerMap;
    }

    ClassMetadata getClassMetadata() {
        return this.classMetadata;
    }

    MethodHandlerMap getMethodHandlerMap() {
        return this.methodHandlerMap;
    }

    public Object invoke(MethodInvocation invocation) {
        Method method = invocation.getMethod();
        if (ReflectionUtils.isToStringMethod((Method)method)) {
            return MethodInvocationHelper.getToStringValueFor(invocation);
        }
        MethodMetadata methodMetadata = this.classMetadata.getMethodMetadata(method);
        MethodHandler methodHandler = this.methodHandlerMap.getMethodHandler(method);
        return methodHandler.handle(invocation.getArguments(), methodMetadata);
    }
}

