/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.icomponent.generic;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.reflect.TypeUtils;

public class GenericTypeParametersCollector {
    private final Map<TypeVariable<?>, Type> typeParameters = new HashMap();

    public GenericTypeParametersCollector(Class<?> clazz) {
        this.collectFromSupertypes(clazz);
    }

    private void collectFromSupertypes(Class<?> clazz) {
        Optional.ofNullable(clazz.getGenericSuperclass()).ifPresent(this::collectFromGenericType);
        Arrays.stream(clazz.getGenericInterfaces()).forEach(this::collectFromGenericType);
    }

    private void collectFromGenericType(Type type) {
        Class actualClass;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            this.collectFromParameterizedType(parameterizedType);
            actualClass = (Class)parameterizedType.getRawType();
        } else {
            actualClass = (Class)type;
        }
        this.collectFromSupertypes(actualClass);
    }

    private void collectFromParameterizedType(ParameterizedType type) {
        Optional.ofNullable(TypeUtils.getTypeArguments((ParameterizedType)type)).ifPresent(this.typeParameters::putAll);
    }

    public Type getValue(TypeVariable<?> type) {
        return this.typeParameters.get(type);
    }
}

