/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.icomponent.generic;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.thepavel.icomponent.generic.GenericTypeParametersCollector;

public class GenericTypeParametersResolver {
    private final GenericTypeParametersCollector parameters;

    public GenericTypeParametersResolver(Class<?> clazz) {
        this.parameters = new GenericTypeParametersCollector(clazz);
    }

    public Type resolveType(Type type) {
        if (type == null) {
            return Object.class;
        }
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            return this.resolveTypeVariable((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return this.resolveArrayType((GenericArrayType)type);
        }
        if (type instanceof ParameterizedType) {
            return this.resolveParameterizedType((ParameterizedType)type);
        }
        return Object.class;
    }

    private Type resolveTypeVariable(TypeVariable<?> typeVariable) {
        return this.resolveType(this.parameters.getValue(typeVariable));
    }

    private Type resolveArrayType(GenericArrayType arrayType) {
        Type componentType = arrayType.getGenericComponentType();
        return TypeUtils.genericArrayType((Type)this.resolveType(componentType));
    }

    private Type resolveParameterizedType(ParameterizedType type) {
        return GenericTypeParametersResolver.allTypeArgumentsResolved(type) ? type : TypeUtils.parameterize((Class)((Class)type.getRawType()), (Type[])this.resolveTypeArguments(type));
    }

    private static boolean allTypeArgumentsResolved(ParameterizedType type) {
        return Arrays.stream(type.getActualTypeArguments()).allMatch(argument -> argument instanceof Class);
    }

    private Type[] resolveTypeArguments(ParameterizedType type) {
        Type[] arguments = type.getActualTypeArguments();
        Type[] resolved = new Type[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            resolved[i] = this.resolveType(arguments[i]);
        }
        return resolved;
    }
}

