/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.icomponent.handler.resolver;

import java.util.List;
import java.util.Objects;
import org.springframework.beans.BeanInstantiationException;
import org.thepavel.icomponent.handler.MethodHandler;
import org.thepavel.icomponent.handler.MethodHandlerMap;
import org.thepavel.icomponent.handler.resolver.MethodHandlerMapResolver;
import org.thepavel.icomponent.handler.resolver.MethodHandlerResolver;
import org.thepavel.icomponent.metadata.ClassMetadata;
import org.thepavel.icomponent.metadata.MethodMetadata;

public class MethodHandlerMapResolverBean
implements MethodHandlerMapResolver {
    private final List<MethodHandlerResolver> methodHandlerResolvers;

    public MethodHandlerMapResolverBean(List<MethodHandlerResolver> methodHandlerResolvers) {
        this.methodHandlerResolvers = methodHandlerResolvers;
    }

    @Override
    public MethodHandlerMap getMethodHandlerMap(ClassMetadata classMetadata) {
        return classMetadata.getMethodsMetadata().stream().collect(MethodHandlerMap.collector(MethodMetadata::getSourceMethod, this::getMethodHandler));
    }

    private MethodHandler getMethodHandler(MethodMetadata methodMetadata) {
        return this.methodHandlerResolvers.stream().map(resolver -> resolver.getMethodHandler(methodMetadata)).filter(Objects::nonNull).findFirst().orElseThrow(() -> MethodHandlerMapResolverBean.noMethodHandlerFound(methodMetadata));
    }

    private static BeanInstantiationException noMethodHandlerFound(MethodMetadata metadata) {
        return new BeanInstantiationException(metadata.getSourceClassMetadata().getSourceClass(), "No method handler found for method " + metadata.getSourceMethod());
    }
}

