/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.icomponent.metadata.validation;

import java.lang.reflect.Method;
import java.util.Optional;
import org.thepavel.icomponent.metadata.ClassMetadata;
import org.thepavel.icomponent.metadata.MethodMetadata;
import org.thepavel.icomponent.metadata.validation.ClassMetadataValidationException;
import org.thepavel.icomponent.metadata.validation.ClassMetadataValidator;
import org.thepavel.icomponent.util.MethodHelper;

public class ClassMetadataValidatorBean
implements ClassMetadataValidator {
    public static final String NAME = "org.thepavel.icomponent.metadata.validation.internalClassMetadataValidatorBean";

    @Override
    public void validate(ClassMetadata classMetadata) throws ClassMetadataValidationException {
        Optional<Method> defaultMethod = ClassMetadataValidatorBean.findDefaultMethod(classMetadata);
        if (defaultMethod.isPresent()) {
            throw ClassMetadataValidatorBean.unsupportedMethod(defaultMethod.get());
        }
    }

    private static Optional<Method> findDefaultMethod(ClassMetadata classMetadata) {
        return classMetadata.getMethodsMetadata().stream().map(MethodMetadata::getSourceMethod).filter(MethodHelper::isDefault).findFirst();
    }

    private static ClassMetadataValidationException unsupportedMethod(Method method) {
        return new ClassMetadataValidationException("Unsupported method " + method);
    }
}

