/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.icomponent.handler.resolver;

import org.springframework.core.type.AnnotatedTypeMetadata;
import org.thepavel.icomponent.Handler;
import org.thepavel.icomponent.handler.MethodHandler;
import org.thepavel.icomponent.handler.resolver.MethodHandlerResolver;
import org.thepavel.icomponent.metadata.MethodMetadata;
import org.thepavel.icomponent.util.AnnotationAttributes;
import org.thepavel.icomponent.util.BeanLookup;

public class HandlerAnnotationMethodHandlerResolver
implements MethodHandlerResolver {
    public static final String NAME = "org.thepavel.icomponent.handler.resolver.internalHandlerAnnotationMethodHandlerResolver";
    private static final String BEAN_NAME = "beanName";
    private static final String BEAN_TYPE = "beanType";
    private final BeanLookup beanLookup;

    public HandlerAnnotationMethodHandlerResolver(BeanLookup beanLookup) {
        this.beanLookup = beanLookup;
    }

    @Override
    public MethodHandler getMethodHandler(MethodMetadata methodMetadata) {
        MethodHandler methodHandler = this.getFromAnnotation(methodMetadata);
        if (methodHandler == null) {
            methodHandler = this.getFromAnnotation(methodMetadata.getSourceClassMetadata());
        }
        return methodHandler;
    }

    private MethodHandler getFromAnnotation(AnnotatedTypeMetadata metadata) {
        AnnotationAttributes<Handler> attributes = AnnotationAttributes.of(Handler.class).declaredOn(metadata);
        String beanName = attributes.getString(BEAN_NAME).orElse(null);
        Class beanType = attributes.getClass(BEAN_TYPE).orElse(null);
        return this.getMethodHandler(beanName, beanType);
    }

    private MethodHandler getMethodHandler(String beanName, Class<?> beanType) {
        return (MethodHandler)this.beanLookup.getBean(beanName, beanType);
    }
}

