/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.icomponent.proxy;

import java.util.List;
import org.aopalliance.intercept.Interceptor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.core.type.AnnotationMetadata;
import org.thepavel.icomponent.metadata.ClassMetadata;
import org.thepavel.icomponent.metadata.factory.ClassMetadataFactory;
import org.thepavel.icomponent.metadata.validation.ClassMetadataValidationException;
import org.thepavel.icomponent.metadata.validation.ClassMetadataValidator;
import org.thepavel.icomponent.proxy.InterfaceComponentInterceptor;
import org.thepavel.icomponent.proxy.InterfaceComponentInterceptorFactory;

public class InterfaceComponentProxyFactory {
    public static final String NAME = "org.thepavel.icomponent.proxy.internalInterfaceComponentProxyFactory";
    private final ClassMetadataFactory classMetadataFactory;
    private final List<ClassMetadataValidator> classMetadataValidators;
    private final InterfaceComponentInterceptorFactory interceptorFactory;

    public InterfaceComponentProxyFactory(ClassMetadataFactory classMetadataFactory, List<ClassMetadataValidator> classMetadataValidators, InterfaceComponentInterceptorFactory interceptorFactory) {
        this.classMetadataFactory = classMetadataFactory;
        this.classMetadataValidators = classMetadataValidators;
        this.interceptorFactory = interceptorFactory;
    }

    public Object createProxy(AnnotationMetadata annotationMetadata) {
        ClassMetadata classMetadata = this.getClassMetadata(annotationMetadata);
        this.validateClassMetadata(classMetadata);
        return this.createProxy(classMetadata);
    }

    private ClassMetadata getClassMetadata(AnnotationMetadata annotationMetadata) {
        return this.classMetadataFactory.getClassMetadata(annotationMetadata);
    }

    private void validateClassMetadata(ClassMetadata classMetadata) {
        for (ClassMetadataValidator classMetadataValidator : this.classMetadataValidators) {
            try {
                classMetadataValidator.validate(classMetadata);
            }
            catch (ClassMetadataValidationException e) {
                throw new BeanInstantiationException(classMetadata.getSourceClass(), e.getMessage());
            }
        }
    }

    private Object createProxy(ClassMetadata classMetadata) {
        return ProxyFactory.getProxy(classMetadata.getSourceClass(), (Interceptor)this.getInterceptor(classMetadata));
    }

    private InterfaceComponentInterceptor getInterceptor(ClassMetadata classMetadata) {
        return this.interceptorFactory.getInterceptor(classMetadata);
    }
}

