/*
 * Decompiled with CFR 0.152.
 */
package org.thepavel.icomponent.util;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class AnnotationAttributes<T extends Annotation> {
    private final Class<T> annotationType;
    private MergedAnnotation<T> annotation;

    private AnnotationAttributes(Class<T> annotationType) {
        this.annotationType = annotationType;
    }

    private AnnotationAttributes(MergedAnnotation<T> annotation) {
        this.annotationType = null;
        this.annotation = annotation;
    }

    public static <T extends Annotation> AnnotationAttributes<T> of(Class<T> annotationType) {
        return new AnnotationAttributes<T>(annotationType);
    }

    public static <T extends Annotation> AnnotationAttributes<T> of(MergedAnnotation<T> annotation) {
        return new AnnotationAttributes<T>(annotation);
    }

    public AnnotationAttributes<T> declaredOn(AnnotatedTypeMetadata metadata) {
        if (this.annotationType == null) {
            throw new IllegalStateException("Annotation type is undefined");
        }
        this.annotation = metadata.getAnnotations().get(this.annotationType);
        return this;
    }

    private MergedAnnotation<T> getAnnotation() {
        if (this.annotation == null) {
            throw new IllegalStateException("Annotation is undefined");
        }
        return this.annotation;
    }

    public Optional<String> getString(String name) {
        return this.getAnnotation().getValue(name, String.class).filter(StringUtils::isNotBlank);
    }

    public Optional<List<String>> getStrings(String name) {
        return this.getAnnotation().getValue(name, String[].class).map(this::filterOutBlankStrings).filter(list -> !list.isEmpty());
    }

    private List<String> filterOutBlankStrings(String[] strings) {
        return Arrays.stream(strings).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public Optional<Class<?>> getClass(String name) {
        return this.getAnnotation().getValue(name, Class.class).map(c -> c);
    }

    public Optional<List<Class<?>>> getClasses(String name) {
        Optional<List> result = this.getAnnotation().getValue(name, Class[].class).map(Arrays::asList);
        return result.filter(list -> !list.isEmpty());
    }

    public Optional<String> getValueAsString() {
        return this.getString("value");
    }

    public Optional<List<String>> getValueAsStrings() {
        return this.getStrings("value");
    }

    public Optional<Class<?>> getValueAsClass() {
        return this.getClass("value");
    }

    public Optional<List<Class<?>>> getValueAsClasses() {
        return this.getClasses("value");
    }
}

