/*
 * Decompiled with CFR 0.152.
 */
package org.thermoweb.generator.name;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thermoweb.generator.name.FirstnameData;
import org.thermoweb.generator.name.Gender;
import org.thermoweb.generator.name.Language;
import org.thermoweb.generator.name.NameGenerator;
import org.thermoweb.generator.name.RandomCollection;
import org.thermoweb.generator.name.Type;

public class FrequencyLoader {
    private static final Logger log = LoggerFactory.getLogger(FrequencyLoader.class);
    private static final String SEMICOLON_DELIMITER = ";";
    private static final String COMMA_DELIMITER = ",";
    private static final int SLICE_WINDOWS = 3;
    private static final Map<Integer, Map<String, RandomCollection<String>>> transitionMapCache = new HashMap<Integer, Map<String, RandomCollection<String>>>();

    private FrequencyLoader() {
    }

    public static List<FirstnameData> loadFirstnames(InputStream firstnameFile) {
        ArrayList<FirstnameData> firstnames = new ArrayList<FirstnameData>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(firstnameFile));){
            String line;
            while ((line = br.readLine()) != null) {
                FrequencyLoader.addFirstname(firstnames, line);
            }
        }
        catch (IOException e) {
            log.atWarn().log("oups : {}", (Object)e.getMessage());
        }
        return firstnames;
    }

    public static List<String> loadNames(InputStream namesFile) {
        ArrayList<String> names = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(namesFile));){
            String line;
            while ((line = br.readLine()) != null) {
                names.add(line.split(COMMA_DELIMITER)[0].toLowerCase());
            }
        }
        catch (IOException e) {
            log.atWarn().log("oups : {}", (Object)e.getMessage());
        }
        return names;
    }

    private static void addFirstname(List<FirstnameData> firstnames, String line) {
        try {
            firstnames.add(new FirstnameData(line.split(SEMICOLON_DELIMITER)));
        }
        catch (IllegalArgumentException e) {
            log.atWarn().log("oups : {}", (Object)e.getMessage());
        }
    }

    public static Map<String, RandomCollection<String>> getTransitionMap(Stream<String> firstnames) {
        log.atInfo().log("calculatin transitions map");
        HashMap transitionMap = new HashMap();
        firstnames.forEach(firstname -> {
            if (firstname.length() <= 2) {
                log.atDebug().log("handle short firstname slicing");
            } else {
                for (int i = 1; i < firstname.length(); ++i) {
                    String precedence = firstname.substring(i > 3 ? i - 3 : 0, i);
                    String nextLetter = String.valueOf(firstname.charAt(i));
                    transitionMap.merge(precedence, Map.of(nextLetter, 1), (old, recent) -> Stream.of(old, recent).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum)));
                }
            }
        });
        HashMap<String, RandomCollection<String>> transitions = new HashMap<String, RandomCollection<String>>();
        for (Map.Entry entry : transitionMap.entrySet()) {
            RandomCollection<String> randomCollection = FrequencyLoader.getStringRandomCollection((Map)entry.getValue());
            transitions.put((String)entry.getKey(), randomCollection);
        }
        return transitions;
    }

    public static Map<String, RandomCollection<String>> getTransitionsMap(Type type, Gender gender, Language language) {
        TransitionKey key = new TransitionKey(type, gender, language);
        return transitionMapCache.computeIfAbsent(key.hashCode(), s -> FrequencyLoader.getStringRandomCollectionMap(type, gender, language));
    }

    private static Map<String, RandomCollection<String>> getStringRandomCollectionMap(Type type, Gender gender, Language language) {
        if (Type.FIRSTNAME.equals((Object)type)) {
            return FrequencyLoader.getTransitionMap(NameGenerator.getFirstnames().stream().filter(f -> Optional.ofNullable(gender).map(g -> g.equals((Object)f.gender())).orElse(true) != false && language.equals((Object)f.language())).map(FirstnameData::firstname));
        }
        return FrequencyLoader.getTransitionMap(NameGenerator.getNames().stream());
    }

    private static RandomCollection<String> getStringRandomCollection(Map<String, Integer> transitions) {
        double total = transitions.values().stream().mapToInt(Integer::intValue).sum();
        RandomCollection<String> randomCollection = new RandomCollection<String>();
        for (Map.Entry<String, Integer> entry : transitions.entrySet()) {
            randomCollection.add((double)entry.getValue().intValue() / total, entry.getKey());
        }
        return randomCollection;
    }

    private record TransitionKey(Type type, Gender gender, Language language) {
    }
}

