/*
 * Decompiled with CFR 0.152.
 */
package org.thermoweb.generator.name;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Language {
    AFRICAN,
    ARABIC,
    ARMENIAN,
    BIBLICAL,
    CHINESE,
    CROATIAN,
    CZECH,
    DANISH,
    DUTCH,
    ENGLISH,
    ENGLISH_BIBLICAL("english, biblical"),
    ENGLISH_JEWISH("english, jewish"),
    ENGLISH_MODERN("english (modern)"),
    FINNISH,
    FRENCH,
    GERMAN,
    GREEK_ANCIENT("ancient greek"),
    GREEK_ANCIENT_LATINIZED("ancient greek (latinized)"),
    GREEK_MYTHOLOGY("greek mythology"),
    GREEK_MYTHOLOGY_LATINIZED("greek mythology (latinized)"),
    HISTORY,
    HUNGARIAN,
    INDIAN,
    IRANIAN,
    IRISH,
    ITALIAN,
    JEWISH,
    LITERATURE,
    NONE,
    POLISH,
    PORTUGUESE,
    RUSSIAN,
    SPANISH,
    SWEDISH,
    TURKISH;

    private static final Logger log;
    private final String code;

    private Language(String code) {
        this.code = code;
    }

    private Language() {
        this.code = this.name().toLowerCase();
    }

    public static Language fromCode(String code) {
        for (Language language : Language.values()) {
            if (!Arrays.stream(code.split(",")).map(String::trim).toList().contains(language.code)) continue;
            return language;
        }
        log.atDebug().log("the code {} does not exist", (Object)code);
        return NONE;
    }

    static {
        log = LoggerFactory.getLogger(Language.class);
    }
}

