/*
 * Decompiled with CFR 0.152.
 */
package org.thermoweb.generator.name;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.random.RandomGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thermoweb.generator.name.FirstnameData;
import org.thermoweb.generator.name.FrequencyLoader;
import org.thermoweb.generator.name.Gender;
import org.thermoweb.generator.name.Language;
import org.thermoweb.generator.name.RandomCollection;
import org.thermoweb.generator.name.Type;

public class NameGenerator {
    private static final Logger log = LoggerFactory.getLogger(NameGenerator.class);
    private static final List<FirstnameData> firstnames = NameGenerator.loadFirstnamesFile();
    private static final List<String> names = NameGenerator.loadNamesFile();
    private static final RandomGenerator generator = RandomGenerator.getDefault();
    private static int maxLength = 30;

    private NameGenerator() {
    }

    public static String getRandomFirstname(Language language) {
        return NameGenerator.getRandomFirstname(language, NameGenerator.getRandomItem(Arrays.stream(Gender.values()).toList()));
    }

    public static String getRandomFirstname(Language language, Gender gender) {
        Map<String, RandomCollection<String>> transitionsMap = FrequencyLoader.getTransitionsMap(Type.FIRSTNAME, gender, language);
        return NameGenerator.generateRandomFirstname(transitionsMap, maxLength);
    }

    public static String generateRandomFirstname(Map<String, RandomCollection<String>> transitionsMap, int length) {
        RandomCollection<String> getNextProbableLetters;
        String firstLetter = NameGenerator.getRandomItem(transitionsMap.keySet().stream().filter(s -> s.length() == 1).toList());
        StringBuilder firstname = new StringBuilder(firstLetter);
        while ((getNextProbableLetters = NameGenerator.getGetNextProbableLetters(transitionsMap, firstname)) != null && firstname.length() <= length) {
            firstname.append(getNextProbableLetters.next());
        }
        return firstname.toString();
    }

    private static RandomCollection<String> getGetNextProbableLetters(Map<String, RandomCollection<String>> transitionsMap, StringBuilder firstname) {
        return transitionsMap.get(firstname.length() < 3 ? firstname.toString() : firstname.substring(firstname.length() - 3));
    }

    private static <T> T getRandomItem(List<T> list) {
        return list.get(generator.nextInt(list.size()));
    }

    private static List<FirstnameData> loadFirstnamesFile() {
        log.atInfo().log("loading firstnames file...");
        return FrequencyLoader.loadFirstnames(Thread.currentThread().getContextClassLoader().getResourceAsStream("firstnames.csv"));
    }

    private static List<String> loadNamesFile() {
        log.atInfo().log("loading names file...");
        return FrequencyLoader.loadNames(Thread.currentThread().getContextClassLoader().getResourceAsStream("names.csv"));
    }

    public static List<FirstnameData> getFirstnames() {
        return firstnames;
    }

    public static List<String> getNames() {
        return names;
    }

    public static void setMaxLength(int maxLength) {
        NameGenerator.maxLength = maxLength;
    }
}

