/*
 * Decompiled with CFR 0.152.
 */
package org.thermoweb.generator.name.commands;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thermoweb.generator.name.FrequencyLoader;
import org.thermoweb.generator.name.Gender;
import org.thermoweb.generator.name.Language;
import org.thermoweb.generator.name.NameGenerator;
import org.thermoweb.generator.name.RandomCollection;
import org.thermoweb.generator.name.Type;
import picocli.CommandLine;

@CommandLine.Command(name="generate")
public class GenerateCommand
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(GenerateCommand.class);
    @CommandLine.Option(names={"--number", "-n"}, defaultValue="10")
    private int number;
    @CommandLine.Option(names={"--size", "-s"}, defaultValue="30")
    private int size;
    @CommandLine.Option(names={"--gender", "-g"})
    private Gender gender;
    @CommandLine.Option(names={"--language", "-l"}, defaultValue="ENGLISH")
    private Language language;
    @CommandLine.Option(names={"--type", "-t"}, defaultValue="firstname")
    private Type type;

    @Override
    public void run() {
        log.atInfo().log("Generating {} {} in {}", new Object[]{this.number, this.type, this.language});
        Map<String, RandomCollection<String>> transitionsMap = FrequencyLoader.getTransitionsMap(this.type, this.gender, this.language);
        for (int i = 0; i < this.number; ++i) {
            String randomFirstname = NameGenerator.generateRandomFirstname(transitionsMap, this.size);
            log.atInfo().log("generated : {}", (Object)randomFirstname);
        }
    }
}

