/*
 * Decompiled with CFR 0.152.
 */
package org.thermoweb.picocli.command;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thermoweb.picocli.config.Config;
import org.thermoweb.picocli.config.Property;
import org.thermoweb.picocli.config.SimpleProperty;
import picocli.CommandLine;

@CommandLine.Command(name="config")
public class ConfigCommand
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ConfigCommand.class);
    private static final String SECRET_PLACEHOLDER = "<secret>";
    @CommandLine.Parameters(index="0", arity="0..1")
    private String propertyName;
    @CommandLine.Parameters(index="1", arity="0..1")
    private String propertyValue;
    @CommandLine.Option(names={"--secret"})
    private boolean isSecret;

    public ConfigCommand() {
        log.atDebug().log();
    }

    @Override
    public void run() {
        Config.setProperty(new SimpleProperty(this.propertyName, this.propertyValue, this.isSecret));
        log.atInfo().log("property '{}' set to '{}'", (Object)this.propertyName, (Object)(this.isSecret ? SECRET_PLACEHOLDER : this.propertyValue));
    }

    @CommandLine.Command(name="list", description={"list all properties"})
    public void list() {
        List<Property> properties = Config.list();
        properties.forEach(p -> log.atInfo().log(String.format("%s : %s", p.id(), p.isSecret() ? SECRET_PLACEHOLDER : p.value())));
    }
}

