package org.thewonderlemming.c4plantuml.grammars;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1ParserBaseListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1ParserListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2ParserBaseListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2ParserListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3ParserBaseListener;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3ParserListener;

/**
 * A simple {@link ParseTreeListener} that implements {@link C4L1ParserListener}, {@link C4L2ParserListener} and
 * {@link C4L3ParserListener} to be able to parse every C4 grammar files using the same class.
 * <p>
 * The default behavior of the methods is to do nothing. You have to override them if you need a specific processing.
 *
 * @author thewonderlemming
 *
 */
public class C4BaseListener
    implements C4L1ParserListenerDecorator, C4L2ParserListenerDecorator, C4L3ParserListenerDecorator {

    private final C4L1ParserBaseListener c4l1Listener = new C4L1ParserBaseListener();

    private final C4L2ParserBaseListener c4l2Listener = new C4L2ParserBaseListener();

    private final C4L3ParserBaseListener c4l3Listener = new C4L3ParserBaseListener();


    /**
     * {@inheritDoc}
     *
     * Enters a parse tree.
     * <p>
     * Does nothing, by default. You have to override it if you want to add custom
     * behavior.
     */
    @Override
    public void enterEveryRule(final ParserRuleContext ctx) {
        // Base silent implementation. Override this to add behavior
    }

    /**
     * {@inheritDoc}
     *
     * Exits a parse tree.
     * <p>
     * Does nothing, by default. You have to override it if you want to add custom
     * behavior.
     */
    @Override
    public void exitEveryRule(final ParserRuleContext ctx) {
        // Base silent implementation. Override this to add behavior
    }

    @Override
    public C4L1ParserListener getDecoratedC4L1ParserListener() {
        return this.c4l1Listener;
    }

    @Override
    public C4L2ParserListener getDecoratedC4L2ParserListener() {
        return this.c4l2Listener;
    }

    @Override
    public C4L3ParserListener getDecoratedC4L3ParserListener() {
        return this.c4l3Listener;
    }

    /**
     * {@inheritDoc}
     *
     * Visits a {@link ErrorNode}.
     * <p>
     * Does nothing, by default. You have to override it if you want to add custom
     * behavior.
     */
    @Override
    public void visitErrorNode(final ErrorNode node) {
        // Base silent implementation. Override this to add behavior
    }

    /**
     * {@inheritDoc}
     *
     * Visits a {@link TerminalNode}.
     * <p>
     * Does nothing, by default. You have to override it if you want to add custom
     * behavior.
     */
    @Override
    public void visitTerminal(final TerminalNode node) {
        // Base silent implementation. Override this to add behavior
    }
}
