package org.thewonderlemming.c4plantuml.grammars;

import org.thewonderlemming.c4plantuml.grammars.generated.C4L1Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1ParserListener;

/**
 * A decorator pattern to {@link C4L1ParserListener} using default methods to emulate multiple inheritance amongst
 * classes and allow simple composition of grammars parsers.
 * <p>
 * All the default implementations delegates the work to the decorated object.
 *
 * @author thewonderlemming
 *
 */
public interface C4L1ParserListenerDecorator extends C4L1ParserListener {

    @Override
    default void enterBoundary(final C4L1Parser.BoundaryContext ctx) {
        getDecoratedC4L1ParserListener().enterBoundary(ctx);
    }

    @Override
    default void enterCloud(final C4L1Parser.CloudContext ctx) {
        getDecoratedC4L1ParserListener().enterCloud(ctx);
    }

    @Override
    default void enterComma(final C4L1Parser.CommaContext ctx) {
        getDecoratedC4L1ParserListener().enterComma(ctx);
    }

    @Override
    default void enterDiagram(final C4L1Parser.DiagramContext ctx) {
        getDecoratedC4L1ParserListener().enterDiagram(ctx);
    }

    @Override
    default void enterEnterprise_boundary(final C4L1Parser.Enterprise_boundaryContext ctx) {
        getDecoratedC4L1ParserListener().enterEnterprise_boundary(ctx);
    }

    @Override
    default void enterFooter(final C4L1Parser.FooterContext ctx) {
        getDecoratedC4L1ParserListener().enterFooter(ctx);
    }

    @Override
    default void enterInclude(final C4L1Parser.IncludeContext ctx) {
        getDecoratedC4L1ParserListener().enterInclude(ctx);
    }

    @Override
    default void enterL1_title(final C4L1Parser.L1_titleContext ctx) {
        getDecoratedC4L1ParserListener().enterL1_title(ctx);
    }

    @Override
    default void enterLayout(final C4L1Parser.LayoutContext ctx) {
        getDecoratedC4L1ParserListener().enterLayout(ctx);
    }

    @Override
    default void enterPerson(final C4L1Parser.PersonContext ctx) {
        getDecoratedC4L1ParserListener().enterPerson(ctx);
    }

    @Override
    default void enterPerson_ext(final C4L1Parser.Person_extContext ctx) {
        getDecoratedC4L1ParserListener().enterPerson_ext(ctx);
    }

    @Override
    default void enterRelationship(final C4L1Parser.RelationshipContext ctx) {
        getDecoratedC4L1ParserListener().enterRelationship(ctx);
    }

    @Override
    default void enterStatement(final C4L1Parser.StatementContext ctx) {
        getDecoratedC4L1ParserListener().enterStatement(ctx);
    }

    @Override
    default void enterSystem(final C4L1Parser.SystemContext ctx) {
        getDecoratedC4L1ParserListener().enterSystem(ctx);
    }

    @Override
    default void enterSystem_ext(final C4L1Parser.System_extContext ctx) {
        getDecoratedC4L1ParserListener().enterSystem_ext(ctx);
    }

    @Override
    default void enterTitle(final C4L1Parser.TitleContext ctx) {
        getDecoratedC4L1ParserListener().enterTitle(ctx);
    }

    @Override
    default void exitBoundary(final C4L1Parser.BoundaryContext ctx) {
        getDecoratedC4L1ParserListener().enterBoundary(ctx);
    }

    @Override
    default void exitCloud(final C4L1Parser.CloudContext ctx) {
        getDecoratedC4L1ParserListener().exitCloud(ctx);
    }

    @Override
    default void exitComma(final C4L1Parser.CommaContext ctx) {
        getDecoratedC4L1ParserListener().exitComma(ctx);
    }

    @Override
    default void exitDiagram(final C4L1Parser.DiagramContext ctx) {
        getDecoratedC4L1ParserListener().exitDiagram(ctx);
    }

    @Override
    default void exitEnterprise_boundary(final C4L1Parser.Enterprise_boundaryContext ctx) {
        getDecoratedC4L1ParserListener().exitEnterprise_boundary(ctx);
    }

    @Override
    default void exitFooter(final C4L1Parser.FooterContext ctx) {
        getDecoratedC4L1ParserListener().exitFooter(ctx);
    }

    @Override
    default void exitInclude(final C4L1Parser.IncludeContext ctx) {
        getDecoratedC4L1ParserListener().exitInclude(ctx);
    }

    @Override
    default void exitL1_title(final C4L1Parser.L1_titleContext ctx) {
        getDecoratedC4L1ParserListener().exitL1_title(ctx);
    }

    @Override
    default void exitLayout(final C4L1Parser.LayoutContext ctx) {
        getDecoratedC4L1ParserListener().exitLayout(ctx);
    }

    @Override
    default void exitPerson(final C4L1Parser.PersonContext ctx) {
        getDecoratedC4L1ParserListener().exitPerson(ctx);
    }

    @Override
    default void exitPerson_ext(final C4L1Parser.Person_extContext ctx) {
        getDecoratedC4L1ParserListener().exitPerson_ext(ctx);
    }

    @Override
    default void exitRelationship(final C4L1Parser.RelationshipContext ctx) {
        getDecoratedC4L1ParserListener().exitRelationship(ctx);
    }

    @Override
    default void exitStatement(final C4L1Parser.StatementContext ctx) {
        getDecoratedC4L1ParserListener().exitStatement(ctx);
    }

    @Override
    default void exitSystem(final C4L1Parser.SystemContext ctx) {
        getDecoratedC4L1ParserListener().exitSystem(ctx);
    }

    @Override
    default void exitSystem_ext(final C4L1Parser.System_extContext ctx) {
        getDecoratedC4L1ParserListener().exitSystem_ext(ctx);
    }

    @Override
    default void exitTitle(final C4L1Parser.TitleContext ctx) {
        getDecoratedC4L1ParserListener().exitTitle(ctx);
    }

    /**
     * returns the instance of the {@link C4L1ParserListener} being decorated.
     *
     * @return the decorated {@link C4L1ParserListener}.
     */
    C4L1ParserListener getDecoratedC4L1ParserListener();
}
