package org.thewonderlemming.c4plantuml.grammars;

import org.thewonderlemming.c4plantuml.grammars.generated.C4L2Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2Parser.FooterContext;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2ParserListener;

/**
 * A decorator pattern to {@link C4L2ParserListener} using default methods to emulate multiple inheritance amongst
 * classes and allow simple composition of grammars parsers.
 * <p>
 * All the default implementations delegates the work to the decorated object.
 *
 * @author thewonderlemming
 *
 */
public interface C4L2ParserListenerDecorator extends C4L2ParserListener {

    @Override
    default void enterBoundary(final C4L2Parser.BoundaryContext ctx) {
        getDecoratedC4L2ParserListener().enterBoundary(ctx);
    }

    @Override
    default void enterCloud(final C4L2Parser.CloudContext ctx) {
        getDecoratedC4L2ParserListener().enterCloud(ctx);
    }

    @Override
    default void enterComma(final C4L2Parser.CommaContext ctx) {
        getDecoratedC4L2ParserListener().enterComma(ctx);
    }

    @Override
    default void enterContainer(final C4L2Parser.ContainerContext ctx) {
        getDecoratedC4L2ParserListener().enterContainer(ctx);
    }

    @Override
    default void enterDiagram(final C4L2Parser.DiagramContext ctx) {
        getDecoratedC4L2ParserListener().enterDiagram(ctx);
    }

    @Override
    default void enterEnterprise_boundary(final C4L2Parser.Enterprise_boundaryContext ctx) {
        getDecoratedC4L2ParserListener().enterEnterprise_boundary(ctx);
    }

    @Override
    default void enterFooter(final FooterContext ctx) {
        getDecoratedC4L2ParserListener().enterFooter(ctx);
    }

    @Override
    default void enterInclude(final C4L2Parser.IncludeContext ctx) {
        getDecoratedC4L2ParserListener().enterInclude(ctx);
    }

    @Override
    default void enterL2_title(final C4L2Parser.L2_titleContext ctx) {
        getDecoratedC4L2ParserListener().enterL2_title(ctx);
    }

    @Override
    default void enterLayout(final C4L2Parser.LayoutContext ctx) {
        getDecoratedC4L2ParserListener().enterLayout(ctx);
    }

    @Override
    default void enterPerson(final C4L2Parser.PersonContext ctx) {
        getDecoratedC4L2ParserListener().enterPerson(ctx);
    }

    @Override
    default void enterPerson_ext(final C4L2Parser.Person_extContext ctx) {
        getDecoratedC4L2ParserListener().enterPerson_ext(ctx);
    }

    @Override
    default void enterRelationship(final C4L2Parser.RelationshipContext ctx) {
        getDecoratedC4L2ParserListener().enterRelationship(ctx);
    }

    @Override
    default void enterStatement(final C4L2Parser.StatementContext ctx) {
        getDecoratedC4L2ParserListener().enterStatement(ctx);
    }

    @Override
    default void enterSystem(final C4L2Parser.SystemContext ctx) {
        getDecoratedC4L2ParserListener().enterSystem(ctx);
    }

    @Override
    default void enterSystem_boundary(final C4L2Parser.System_boundaryContext ctx) {
        getDecoratedC4L2ParserListener().enterSystem_boundary(ctx);
    }

    @Override
    default void enterSystem_ext(final C4L2Parser.System_extContext ctx) {
        getDecoratedC4L2ParserListener().enterSystem_ext(ctx);
    }

    @Override
    default void enterTitle(final C4L2Parser.TitleContext ctx) {
        getDecoratedC4L2ParserListener().enterTitle(ctx);
    }

    @Override
    default void exitBoundary(final C4L2Parser.BoundaryContext ctx) {
        getDecoratedC4L2ParserListener().exitBoundary(ctx);
    }

    @Override
    default void exitCloud(final C4L2Parser.CloudContext ctx) {
        getDecoratedC4L2ParserListener().exitCloud(ctx);
    }

    @Override
    default void exitComma(final C4L2Parser.CommaContext ctx) {
        getDecoratedC4L2ParserListener().exitComma(ctx);
    }

    @Override
    default void exitContainer(final C4L2Parser.ContainerContext ctx) {
        getDecoratedC4L2ParserListener().exitContainer(ctx);
    }

    @Override
    default void exitDiagram(final C4L2Parser.DiagramContext ctx) {
        getDecoratedC4L2ParserListener().exitDiagram(ctx);
    }

    @Override
    default void exitEnterprise_boundary(final C4L2Parser.Enterprise_boundaryContext ctx) {
        getDecoratedC4L2ParserListener().exitEnterprise_boundary(ctx);
    }

    @Override
    default void exitFooter(final FooterContext ctx) {
        getDecoratedC4L2ParserListener().exitFooter(ctx);
    }

    @Override
    default void exitInclude(final C4L2Parser.IncludeContext ctx) {
        getDecoratedC4L2ParserListener().exitInclude(ctx);
    }

    @Override
    default void exitL2_title(final C4L2Parser.L2_titleContext ctx) {
        getDecoratedC4L2ParserListener().exitL2_title(ctx);
    }

    @Override
    default void exitLayout(final C4L2Parser.LayoutContext ctx) {
        getDecoratedC4L2ParserListener().exitLayout(ctx);
    }

    @Override
    default void exitPerson(final C4L2Parser.PersonContext ctx) {
        getDecoratedC4L2ParserListener().exitPerson(ctx);
    }

    @Override
    default void exitPerson_ext(final C4L2Parser.Person_extContext ctx) {
        getDecoratedC4L2ParserListener().exitPerson_ext(ctx);
    }

    @Override
    default void exitRelationship(final C4L2Parser.RelationshipContext ctx) {
        getDecoratedC4L2ParserListener().exitRelationship(ctx);
    }

    @Override
    default void exitStatement(final C4L2Parser.StatementContext ctx) {
        getDecoratedC4L2ParserListener().exitStatement(ctx);
    }

    @Override
    default void exitSystem(final C4L2Parser.SystemContext ctx) {
        getDecoratedC4L2ParserListener().exitSystem(ctx);
    }

    @Override
    default void exitSystem_boundary(final C4L2Parser.System_boundaryContext ctx) {
        getDecoratedC4L2ParserListener().exitSystem_boundary(ctx);
    }

    @Override
    default void exitSystem_ext(final C4L2Parser.System_extContext ctx) {
        getDecoratedC4L2ParserListener().exitSystem_ext(ctx);
    }

    @Override
    default void exitTitle(final C4L2Parser.TitleContext ctx) {
        getDecoratedC4L2ParserListener().exitTitle(ctx);
    }

    /**
     * returns the instance of the {@link C4L2ParserListener} being decorated.
     *
     * @return the decorated {@link C4L2ParserListener}.
     */
    C4L2ParserListener getDecoratedC4L2ParserListener();
}
