package org.thewonderlemming.c4plantuml.grammars;

import org.thewonderlemming.c4plantuml.grammars.generated.C4L3Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3Parser.FooterContext;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3ParserListener;

/**
 * A decorator pattern to {@link C4L3ParserListener} using default methods to emulate multiple inheritance amongst
 * classes and allow simple composition of grammars parsers.
 * <p>
 * All the default implementations delegates the work to the decorated object.
 *
 * @author thewonderlemming
 *
 */
public interface C4L3ParserListenerDecorator extends C4L3ParserListener {

    @Override
    default void enterBoundary(final C4L3Parser.BoundaryContext ctx) {
        getDecoratedC4L3ParserListener().enterBoundary(ctx);
    }

    @Override
    default void enterCloud(final C4L3Parser.CloudContext ctx) {
        getDecoratedC4L3ParserListener().enterCloud(ctx);
    }

    @Override
    default void enterComma(final C4L3Parser.CommaContext ctx) {
        getDecoratedC4L3ParserListener().enterComma(ctx);
    }

    @Override
    default void enterComponent(final C4L3Parser.ComponentContext ctx) {
        getDecoratedC4L3ParserListener().enterComponent(ctx);
    }

    @Override
    default void enterContainer(final C4L3Parser.ContainerContext ctx) {
        getDecoratedC4L3ParserListener().enterContainer(ctx);
    }

    @Override
    default void enterContainer_boundary(final C4L3Parser.Container_boundaryContext ctx) {
        getDecoratedC4L3ParserListener().enterContainer_boundary(ctx);
    }

    @Override
    default void enterDiagram(final C4L3Parser.DiagramContext ctx) {
        getDecoratedC4L3ParserListener().enterDiagram(ctx);
    }

    @Override
    default void enterEnterprise_boundary(final C4L3Parser.Enterprise_boundaryContext ctx) {
        getDecoratedC4L3ParserListener().enterEnterprise_boundary(ctx);
    }

    @Override
    default void enterFooter(final FooterContext ctx) {
        getDecoratedC4L3ParserListener().enterFooter(ctx);
    }

    @Override
    default void enterInclude(final C4L3Parser.IncludeContext ctx) {
        getDecoratedC4L3ParserListener().enterInclude(ctx);
    }

    @Override
    default void enterL3_title(final C4L3Parser.L3_titleContext ctx) {
        getDecoratedC4L3ParserListener().enterL3_title(ctx);
    }

    @Override
    default void enterLayout(final C4L3Parser.LayoutContext ctx) {
        getDecoratedC4L3ParserListener().enterLayout(ctx);
    }

    @Override
    default void enterPerson(final C4L3Parser.PersonContext ctx) {
        getDecoratedC4L3ParserListener().enterPerson(ctx);
    }

    @Override
    default void enterPerson_ext(final C4L3Parser.Person_extContext ctx) {
        getDecoratedC4L3ParserListener().enterPerson_ext(ctx);
    }

    @Override
    default void enterRelationship(final C4L3Parser.RelationshipContext ctx) {
        getDecoratedC4L3ParserListener().enterRelationship(ctx);
    }

    @Override
    default void enterStatement(final C4L3Parser.StatementContext ctx) {
        getDecoratedC4L3ParserListener().enterStatement(ctx);
    }

    @Override
    default void enterSystem(final C4L3Parser.SystemContext ctx) {
        getDecoratedC4L3ParserListener().enterSystem(ctx);
    }

    @Override
    default void enterSystem_ext(final C4L3Parser.System_extContext ctx) {
        getDecoratedC4L3ParserListener().enterSystem_ext(ctx);
    }

    @Override
    default void enterTitle(final C4L3Parser.TitleContext ctx) {
        getDecoratedC4L3ParserListener().enterTitle(ctx);
    }

    @Override
    default void exitBoundary(final C4L3Parser.BoundaryContext ctx) {
        getDecoratedC4L3ParserListener().exitBoundary(ctx);
    }

    @Override
    default void exitCloud(final C4L3Parser.CloudContext ctx) {
        getDecoratedC4L3ParserListener().exitCloud(ctx);
    }

    @Override
    default void exitComma(final C4L3Parser.CommaContext ctx) {
        getDecoratedC4L3ParserListener().exitComma(ctx);
    }

    @Override
    default void exitComponent(final C4L3Parser.ComponentContext ctx) {
        getDecoratedC4L3ParserListener().exitComponent(ctx);
    }

    @Override
    default void exitContainer(final C4L3Parser.ContainerContext ctx) {
        getDecoratedC4L3ParserListener().exitContainer(ctx);
    }

    @Override
    default void exitContainer_boundary(final C4L3Parser.Container_boundaryContext ctx) {
        getDecoratedC4L3ParserListener().exitContainer_boundary(ctx);
    }

    @Override
    default void exitDiagram(final C4L3Parser.DiagramContext ctx) {
        getDecoratedC4L3ParserListener().exitDiagram(ctx);
    }

    @Override
    default void exitEnterprise_boundary(final C4L3Parser.Enterprise_boundaryContext ctx) {
        getDecoratedC4L3ParserListener().exitEnterprise_boundary(ctx);
    }

    @Override
    default void exitFooter(final FooterContext ctx) {
        getDecoratedC4L3ParserListener().exitFooter(ctx);
    }

    @Override
    default void exitInclude(final C4L3Parser.IncludeContext ctx) {
        getDecoratedC4L3ParserListener().exitInclude(ctx);
    }

    @Override
    default void exitL3_title(final C4L3Parser.L3_titleContext ctx) {
        getDecoratedC4L3ParserListener().exitL3_title(ctx);
    }

    @Override
    default void exitLayout(final C4L3Parser.LayoutContext ctx) {
        getDecoratedC4L3ParserListener().exitLayout(ctx);
    }

    @Override
    default void exitPerson(final C4L3Parser.PersonContext ctx) {
        getDecoratedC4L3ParserListener().exitPerson(ctx);
    }

    @Override
    default void exitPerson_ext(final C4L3Parser.Person_extContext ctx) {
        getDecoratedC4L3ParserListener().exitPerson_ext(ctx);
    }

    @Override
    default void exitRelationship(final C4L3Parser.RelationshipContext ctx) {
        getDecoratedC4L3ParserListener().exitRelationship(ctx);
    }

    @Override
    default void exitStatement(final C4L3Parser.StatementContext ctx) {
        getDecoratedC4L3ParserListener().exitStatement(ctx);
    }

    @Override
    default void exitSystem(final C4L3Parser.SystemContext ctx) {
        getDecoratedC4L3ParserListener().exitSystem(ctx);
    }

    @Override
    default void exitSystem_ext(final C4L3Parser.System_extContext ctx) {
        getDecoratedC4L3ParserListener().exitSystem_ext(ctx);
    }

    @Override
    default void exitTitle(final C4L3Parser.TitleContext ctx) {
        getDecoratedC4L3ParserListener().exitTitle(ctx);
    }

    /**
     * returns the instance of the {@link C4L3ParserListener} being decorated.
     *
     * @return the decorated {@link C4L3ParserListener}.
     */
    C4L3ParserListener getDecoratedC4L3ParserListener();
}
