/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testbed.grammars.junit;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C4SamplesFinder {
    private static final String ERROR_CAUGHT_MSG = "Error caught while trying to retrieve samples";
    private static Logger LOGGER = LoggerFactory.getLogger(C4SamplesFinder.class);
    private static final String RETURNING_NO_SAMPLES_MSG = "Returning no sample files.";

    public static Stream<Path> find(Path samplesDirectory) {
        if (samplesDirectory.toFile().exists() && samplesDirectory.toFile().isDirectory()) {
            try {
                return Files.walk(samplesDirectory, new FileVisitOption[0]).filter(path -> path.toFile().isFile()).filter(path -> path.toString().toLowerCase().endsWith(".puml"));
            }
            catch (IOException e) {
                LOGGER.error(ERROR_CAUGHT_MSG, (Throwable)e);
            }
        }
        LOGGER.warn(RETURNING_NO_SAMPLES_MSG);
        return Stream.of(new Path[0]);
    }

    public static Stream<Path> find(URL samplesDirectory) {
        if (null != samplesDirectory) {
            try {
                return C4SamplesFinder.find(Paths.get(samplesDirectory.toURI()));
            }
            catch (URISyntaxException e) {
                LOGGER.error(ERROR_CAUGHT_MSG, (Throwable)e);
            }
        }
        LOGGER.warn(RETURNING_NO_SAMPLES_MSG);
        return Stream.of(new Path[0]);
    }
}

