/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testbed.grammars.junit;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.testbed.grammars.junit.C4SamplesFinder;
import org.thewonderlemming.c4plantuml.testbed.grammars.junit.ParsingErrorListener;

public class GrammarValidationTestFactory<L extends Lexer, P extends Parser> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrammarValidationTestFactory.class);
    private static final String TEST_PREFIX = "shouldParseGrammarWithoutWarnings_givenPath";
    private final Class<L> lexerClass;
    private final Class<P> parserClass;
    private final ParseTreeListener parseTreeListener;
    private final Function<P, ParseTree> parseTreeSupplier;

    public GrammarValidationTestFactory(Class<L> lexerClass, Class<P> parserClass, Function<P, ParseTree> parseTreeSupplier, ParseTreeListener parseTreeListener) {
        this.lexerClass = lexerClass;
        this.parserClass = parserClass;
        this.parseTreeSupplier = parseTreeSupplier;
        this.parseTreeListener = parseTreeListener;
    }

    public Collection<DynamicTest> generateTests(Class<?> testClass, String samplesRootDirectory) {
        String samplesRootDirPath = String.format("/%s/%s", testClass.getPackage().getName(), samplesRootDirectory).replaceAll("\\.", "/");
        return this.generateTests(samplesRootDirPath);
    }

    public Collection<DynamicTest> generateTests(String samplesRootDirectory) {
        Collection tests = C4SamplesFinder.find(this.getClass().getResource(samplesRootDirectory)).map(path -> {
            LOGGER.debug("DEBUG >>> " + path);
            return path;
        }).map(path -> DynamicTest.dynamicTest((String)(TEST_PREFIX + path.toString()), (Executable)this.createTestExecutable((Path)path))).collect(Collectors.toList());
        if (tests.isEmpty()) {
            LOGGER.warn("Could not generate any test for grammar {} / {} because no sample files were to be found in {}", new Object[]{this.lexerClass.getSimpleName(), this.parserClass.getSimpleName(), samplesRootDirectory});
        }
        return tests;
    }

    private Executable createTestExecutable(Path samplePath) {
        return () -> {
            try {
                CharStream stream = CharStreams.fromPath((Path)samplePath, (Charset)StandardCharsets.UTF_8);
                Lexer lexer = (Lexer)this.lexerClass.getDeclaredConstructor(CharStream.class).newInstance(stream);
                lexer.removeErrorListeners();
                lexer.addErrorListener((ANTLRErrorListener)ParsingErrorListener.INSTANCE);
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                Parser parser = (Parser)this.parserClass.getDeclaredConstructor(TokenStream.class).newInstance(tokens);
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)ParsingErrorListener.INSTANCE);
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
                ParseTree tree = this.parseTreeSupplier.apply(parser);
                Assertions.assertThat((Object)tree).isNotNull();
                new ParseTreeWalker().walk(this.parseTreeListener, tree);
            }
            catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.error("Something went wrong as the lexer or the parser could not be instantiated", (Throwable)e);
                org.junit.jupiter.api.Assertions.fail((String)"Failed to validate grammar because of an instantiation issue. Check your code");
            }
        };
    }
}

