/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.testbed.grammars.testrig;

import java.nio.file.Path;
import org.antlr.v4.gui.TestRig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.testbed.grammars.testrig.C4Grammar;

public enum TestRigRunner {
    DIAGNOSE("diagnostics"),
    GUI("gui"),
    TOKENS("tokens"),
    TREE("tree");

    private static final Logger LOGGER;
    private final String mode;

    private TestRigRunner(String mode) {
        this.mode = "-" + mode;
    }

    public void run(Path filename, C4Grammar grammar, String ruleName) throws Exception {
        LOGGER.info("Running TestRig with filename: {}\\n\\tMode: {}\\n\\n", (Object)filename, (Object)this.name());
        TestRig.main((String[])new String[]{grammar.getName(), ruleName, this.mode, filename.toFile().getAbsolutePath()});
    }

    static {
        LOGGER = LoggerFactory.getLogger(TestRigRunner.class);
    }
}

