/*
 * Decompiled with CFR 0.152.
 */
package org.thewonderlemming.c4plantuml.grammars;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1Lexer;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L1Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2Lexer;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L2Parser;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3Lexer;
import org.thewonderlemming.c4plantuml.grammars.generated.C4L3Parser;

public enum SourceType {
    C4_L1(C4L1Lexer.class, C4L1Parser.class, "c4l1", "C4_L1"),
    C4_L2(C4L2Lexer.class, C4L2Parser.class, "c4l2", "C4_L2"),
    C4_L3(C4L3Lexer.class, C4L3Parser.class, "c4l3", "C4_L3");

    private static final Logger LOGGER;
    private static final Map<String, SourceType> SOURCE_TYPES_BY_FILENAME;
    private final String filenameStartsWith;
    private final String level;
    private final Class<? extends Lexer> lexerClass;
    private final Class<? extends Parser> parserClass;

    public static Optional<SourceType> getSourceTypeFromFilename(Path fullyQualifiedName) {
        String filename = fullyQualifiedName.getFileName().toString();
        for (Map.Entry<String, SourceType> entry : SOURCE_TYPES_BY_FILENAME.entrySet()) {
            if (!filename.toLowerCase().startsWith(entry.getKey())) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    private SourceType(Class<? extends Lexer> lexerClass, Class<? extends Parser> parserClass, String filenameStartsWith, String level) {
        this.lexerClass = lexerClass;
        this.parserClass = parserClass;
        this.filenameStartsWith = filenameStartsWith;
        this.level = level;
    }

    public Optional<? extends Parser> createParser(Path sourcePath, Charset charset, BaseErrorListener errorListener) {
        try {
            CharStream stream = CharStreams.fromPath((Path)sourcePath, (Charset)charset);
            Lexer lexer = this.lexerClass.getDeclaredConstructor(CharStream.class).newInstance(stream);
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)errorListener);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            Parser parser = this.parserClass.getDeclaredConstructor(TokenStream.class).newInstance(tokens);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)errorListener);
            return Optional.ofNullable(parser);
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error("Something went wrong as the lexer or the parser could not be instantiated", (Throwable)e);
            return Optional.empty();
        }
    }

    public String getC4Level() {
        return this.level;
    }

    public Class<Parser> getParserType() {
        return this.parserClass;
    }

    static {
        LOGGER = LoggerFactory.getLogger(SourceType.class);
        SOURCE_TYPES_BY_FILENAME = new HashMap<String, SourceType>();
        for (SourceType sourceType : SourceType.values()) {
            SOURCE_TYPES_BY_FILENAME.put(sourceType.filenameStartsWith, sourceType);
        }
    }
}

