package org.thewonderlemming.c4plantuml.graphml;

import java.util.function.Function;

import org.thewonderlemming.c4plantuml.graphml.model.GraphMLModel;

/**
 * A basic Java {@link Function} to create fluent builders such as for the {@link GraphMLModel#builder()} design
 * pattern.
 *
 * @author thewonderlemming
 *
 * @param <T> the type of the result of the function.
 */
@FunctionalInterface
public interface Build<T> {

    /**
     * Returns a result of type T.
     *
     * @return the results of the function.
     */
    T build();
}
