package org.thewonderlemming.c4plantuml.graphml;

import org.antlr.v4.runtime.BaseErrorListener;

/**
 * An implementation of the ANTLR 4 {@link BaseErrorListener}.
 * <p>
 * It is a singleton pattern.
 *
 * @author thewonderlemming
 *
 */
public class C4ErrorListener extends BaseErrorListener {

    private static final C4ErrorListener INSTANCE = new C4ErrorListener();


    /**
     * Returns the current instance of that singleton.
     *
     * @return the singleton instance.
     */
    public static C4ErrorListener getInstance() {
        return INSTANCE;
    }

    private C4ErrorListener() {
    }
}
