package org.thewonderlemming.c4plantuml.graphml.model;

/**
 * Represents a C4 keyword or "entity" as I like to call them. Its purpose is to avoid misspelling in the code.
 *
 * @author thewonderlemming
 *
 */
public enum EntityType {

    /**
     * The C4 System Context {@code Boundary} keyword.
     */
    C1_BOUNDARY(EntityType.BOUNDARY),

    /**
     * The C4 System Context {@code Cloud} keyword.
     */
    C1_CLOUD(EntityType.CLOUD),

    /**
     * The C4 System Context {@code EnterpriseBoundary} keyword.
     */
    C1_ENTERPRISE_BOUNDARY(EntityType.ENTERPRISE_BOUNDARY),

    /**
     * The C4 System Context {@code Layout} keyword.
     */
    C1_LAYOUT(EntityType.LAYOUT),

    /**
     * The C4 System Context {@code Person} keyword.
     */
    C1_PERSON(EntityType.PERSON),

    /**
     * The C4 System Context {@code PersonExt} keyword.
     */
    C1_PERSON_EXT(EntityType.PERSON_EXT),

    /**
     * The C4 System Context {@code System} keyword.
     */
    C1_SYSTEM(EntityType.SYSTEM),

    /**
     * The C4 System Context {@code SystemExt} keyword.
     */
    C1_SYSTEM_EXT(EntityType.SYSTEM_EXT),


    /**
     * The C4 Container {@code Boundary} keyword.
     */
    C2_BOUNDARY(EntityType.BOUNDARY),

    /**
     * The C4 Container {@code Cloud} keyword.
     */
    C2_CLOUD(EntityType.CLOUD),

    /**
     * The C4 Container {@code Container} keyword.
     */
    C2_CONTAINER(EntityType.CONTAINER),

    /**
     * The C4 Container {@code ContainerDb} keyword.
     */
    C2_CONTAINER_DB(EntityType.CONTAINER_DB),

    /**
     * The C4 Container {@code EnterpriseBoundary} keyword.
     */
    C2_ENTERPRISE_BOUNDARY(EntityType.ENTERPRISE_BOUNDARY),

    /**
     * The C4 Container {@code Layout} keyword.
     */
    C2_LAYOUT(EntityType.LAYOUT),

    /**
     * The C4 Container {@code Person} keyword.
     */
    C2_PERSON(EntityType.PERSON),

    /**
     * The C4 Container {@code PersonExt} keyword.
     */
    C2_PERSON_EXT(EntityType.PERSON_EXT),

    /**
     * The C4 Container {@code System} keyword.
     */
    C2_SYSTEM(EntityType.SYSTEM),

    /**
     * The C4 Container {@code SystemBoundary} keyword.
     */
    C2_SYSTEM_BOUNDARY("SystemBoundary"),

    /**
     * The C4 Container {@code SystemExt} keyword.
     */
    C2_SYSTEM_EXT(EntityType.SYSTEM_EXT),


    /**
     * The C4 Component {@code Boundary} keyword.
     */
    C3_BOUNDARY(EntityType.BOUNDARY),

    /**
     * The C4 Component {@code Cloud} keyword.
     */
    C3_CLOUD(EntityType.CLOUD),

    /**
     * The C4 Component {@code Component} keyword.
     */
    C3_COMPONENT("Component"),

    /**
     * The C4 Component {@code ComponentDb} keyword.
     */
    C3_COMPONENT_DB("ComponentDb"),

    /**
     * The C4 Component {@code Container} keyword.
     */
    C3_CONTAINER(EntityType.CONTAINER),

    /**
     * The C4 Component {@code ComponentBoundary} keyword.
     */
    C3_CONTAINER_BOUNDARY("ComponentBoundary"),

    /**
     * The C4 Component {@code ContainerDb} keyword.
     */
    C3_CONTAINER_DB(EntityType.CONTAINER_DB),

    /**
     * The C4 Component {@code EnterpriseBoundary} keyword.
     */
    C3_ENTERPRISE_BOUNDARY(EntityType.ENTERPRISE_BOUNDARY),

    /**
     * The C4 Component {@code Layout} keyword.
     */
    C3_LAYOUT(EntityType.LAYOUT),

    /**
     * The C4 Component {@code Person} keyword.
     */
    C3_PERSON(EntityType.PERSON),

    /**
     * The C4 Component {@code PersonExt} keyword.
     */
    C3_PERSON_EXT(EntityType.PERSON_EXT),

    /**
     * The C4 Component {@code System} keyword.
     */
    C3_SYSTEM(EntityType.SYSTEM),

    /**
     * The C4 Component {@code SystemExt} keyword.
     */
    C3_SYSTEM_EXT(EntityType.SYSTEM_EXT);


    private static final String BOUNDARY = "Boundary";

    private static final String CLOUD = "Cloud";

    private static final String CONTAINER = "Container";

    private static final String CONTAINER_DB = "ContainerDb";

    private static final String ENTERPRISE_BOUNDARY = "EnterpriseBoundary";

    private static final String LAYOUT = "Layout";

    private static final String PERSON = "Person";

    private static final String PERSON_EXT = "PersonExt";

    private static final String SYSTEM = "System";

    private static final String SYSTEM_EXT = "SystemExt";

    private final String typeAsString;


    private EntityType(final String typeAsString) {
        this.typeAsString = typeAsString;
    }

    /**
     * Returns the C4 keyword represented by the current value of {@link EntityType}.
     *
     * @return the current C4 keyword/entity.
     */
    public String getTypeAsString() {
        return this.typeAsString;
    }
}
