package org.thewonderlemming.c4plantuml.graphml.model;

import java.util.function.Function;

import org.thewonderlemming.c4plantuml.grammars.SourceType;

/**
 * A basic Java {@link Function} to create fluent builders such as {@link GraphMLModel#builder()}.
 *
 * @author thewonderlemming
 *
 * @param <T> the type of the result of the function.
 */
@FunctionalInterface
public interface WithC4Level<T> {

    /**
     * A semantic call to pass a {@link SourceType#C4_L1} value to the current function.
     *
     * @return the results of the function.
     */
    default T withC4L1Level() {
        return withC4Level(SourceType.C4_L1.getC4Level());
    }

    /**
     * A semantic call to pass a {@link SourceType#C4_L2} value to the current function.
     *
     * @return the results of the function.
     */
    default T withC4L2Level() {
        return withC4Level(SourceType.C4_L2.getC4Level());
    }

    /**
     * A semantic call to pass a {@link SourceType#C4_L3} value to the current function.
     *
     * @return the results of the function.
     */
    default T withC4L3Level() {
        return withC4Level(SourceType.C4_L3.getC4Level());
    }

    /**
     * Takes a {@link String}, processes it and returns a results of type T.
     *
     * @param level the parameter given to the function.
     * @return the results of the function.
     */
    T withC4Level(final String level);
}
