package org.thewonderlemming.c4plantuml.graphml.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

/**
 * A basic Java {@link Function} to create fluent builders such as {@link GraphMLModel#builder()}.
 *
 * @author thewonderlemming
 *
 * @param <U> the type of the result of the function.
 */
@FunctionalInterface
public interface WithData<U> {

    /**
     * Takes a list of {@link DataModel}, processes it and returns a results of type U.
     *
     * @param data the parameter given to the function.
     * @return the results of the function.
     */
    U withData(final List<DataModel> data);

    /**
     * A semantic call to pass no value to the current function.
     *
     * @return the results of the function.
     */
    default U withoutData() {
        return withData(new ArrayList<>());
    }
}
