package org.thewonderlemming.c4plantuml.graphml.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

/**
 * A basic Java {@link Function} to create fluent builders such as {@link GraphMLModel#builder()}.
 *
 * @author thewonderlemming
 *
 * @param <T> the type of the result of the function.
 */
@FunctionalInterface
public interface WithGraphs<T> {

    /**
     * Takes a list of {@link GraphModel}, processes it and returns a results of type T.
     *
     * @param graphs the parameter given to the function.
     * @return the results of the function.
     */
    T withGraphs(final List<GraphModel> graphs);

    /**
     * A semantic call to pass no value to the current function.
     *
     * @return the results of the function.
     */
    default T withoutGraphs() {
        return withGraphs(new ArrayList<>());
    }
}
