package org.thewonderlemming.c4plantuml.graphml.model;

import java.util.function.Function;

/**
 * A basic Java {@link Function} to create fluent builders such as {@link GraphMLModel#builder()}.
 *
 * @author thewonderlemming
 *
 * @param <T> the type of the result of the function.
 */
@FunctionalInterface
public interface WithLabel<T> {

    /**
     * Takes a {@link String}, processes it and returns a results of type T.
     *
     * @param label the parameter given to the function.
     * @return the results of the function.
     */
    T withLabel(final String label);
}
